/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import java.nio.charset.Charset;
import java.util.Arrays;

class RawString {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private final byte[] data;
    private Charset charset;

    RawString(String string) {
        this(string, UTF8);
    }

    RawString(String string, Charset charset) {
        this.data = string.getBytes(charset);
        this.charset = charset;
    }

    RawString(byte[] bytes) {
        this.data = (byte[])bytes.clone();
        this.charset = UTF8;
    }

    public Charset getCharset() {
        return this.charset;
    }

    void setCharset(Charset charset) {
        this.charset = charset;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public String toString() {
        return new String(this.data, this.charset == null ? UTF8 : this.charset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawString rawString = (RawString)o;
        if (!Arrays.equals(this.data, rawString.data)) {
            return false;
        }
        return !(this.charset != null ? !this.charset.equals(rawString.charset) : rawString.charset != null);
    }

    public int hashCode() {
        int result = this.data != null ? Arrays.hashCode(this.data) : 0;
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        return result;
    }
}

