/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.marshal.GemVersion;
import org.sonatype.nexus.repository.rubygems.marshal.Marshaled;
import org.sonatype.nexus.repository.rubygems.marshal.RubyString;

public class SpecsIndex
implements Marshaled<Object> {
    public static final int NAME = 0;
    public static final int VERSION = 1;
    public static final int PLATFORM = 2;
    public static final SpecsIndex EMPTY = new SpecsIndex(Collections.emptyList());
    private LinkedHashSet<List<?>> list;

    public SpecsIndex() {
        this.list = new LinkedHashSet();
    }

    public SpecsIndex(Collection<List<?>> list) {
        this.list = new LinkedHashSet(list);
    }

    public void merge(Collection<List<?>> more) {
        this.list.addAll(more);
    }

    public SpecsIndex toLatest() throws IOException {
        HashMap<String, List> merged = new HashMap<String, List>();
        for (List list : this.list) {
            String key = String.valueOf(list.get(0).toString()) + list.get(2).toString();
            List other = (List)merged.get(key);
            if (other != null && ((GemVersion)list.get(1)).compareTo((GemVersion)other.get(1)) <= 0) continue;
            merged.put(key, list);
        }
        return new SpecsIndex(merged.values());
    }

    public void add(GemCoordinate gem) {
        List data = gem.toList();
        if (!this.list.contains(data)) {
            this.list.add(data);
        }
    }

    public boolean remove(GemCoordinate gem) {
        return this.list.remove(gem.toList());
    }

    public void removeAll(String name, GemVersion version) {
        RubyString rname = new RubyString(name);
        this.list.removeIf(entry -> entry.get(0).equals(rname) && entry.get(1).equals(version));
    }

    public Collection<List<?>> getList() {
        return this.list;
    }

    @Override
    public Object marshalDump() {
        return this.list;
    }

    @Override
    public void marshalLoad(Object data) {
        this.list = new LinkedHashSet((Collection)data);
    }

    public String toString() {
        return this.list.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecsIndex that = (SpecsIndex)o;
        return Objects.equals(this.list, that.list);
    }

    public int hashCode() {
        return this.list != null ? this.list.hashCode() : 0;
    }
}

