/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import java.util.ArrayList;
import java.util.List;

public class Symbol
implements Comparable<Symbol> {
    private static final Factory factory = new Factory();
    public final String name;

    private Symbol(String name) {
        this.name = name;
    }

    public static Symbol create(String string) {
        return factory.create(string);
    }

    @Override
    public int compareTo(Symbol o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return !(this.name != null ? !this.name.equals(symbol.name) : symbol.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return ":" + this.name;
    }

    /* synthetic */ Symbol(String string, Symbol symbol) {
        this(string);
    }

    static class Factory {
        private final List<Symbol> cache = new ArrayList<Symbol>();

        Factory() {
        }

        Symbol create(String string) {
            Symbol symbol = new Symbol(string, null);
            int i = this.cache.indexOf(symbol);
            if (i > -1) {
                return this.cache.get(i);
            }
            this.cache.add(symbol);
            return symbol;
        }

        int indexOf(Symbol symbol) {
            return this.cache.indexOf(symbol);
        }

        Symbol get(int index) {
            return this.cache.get(index);
        }
    }
}

