/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.sonatype.nexus.repository.rubygems.marshal.UserDefMarshaled;

class Time
extends UserDefMarshaled<byte[]> {
    Time() {
        this(new DateTime(), 0L);
    }

    Time(DateTime dateTime, long nanoSeconds) {
        super("Time", Time.mdump(dateTime, nanoSeconds));
    }

    private static DateTime mload(byte[] fromAsBytes) {
        Preconditions.checkArgument((fromAsBytes.length == 8 ? 1 : 0) != 0, (Object)"marshaled time format differ");
        DateTime dateTime = new DateTime(DateTimeZone.UTC);
        int p = 0;
        int s = 0;
        int i = 0;
        while (i < 4) {
            p |= (fromAsBytes[i] & 0xFF) << 8 * i;
            ++i;
        }
        i = 4;
        while (i < 8) {
            s |= (fromAsBytes[i] & 0xFF) << 8 * (i - 4);
            ++i;
        }
        boolean utc = false;
        if ((p & Integer.MIN_VALUE) == 0) {
            dateTime = dateTime.withMillis((long)p * 1000L);
        } else {
            utc = ((p &= Integer.MAX_VALUE) >>> 30 & 1) == 1;
            dateTime = dateTime.withYear((p >>> 14 & 0xFFFF) + 1900);
            dateTime = dateTime.withMonthOfYear((p >>> 10 & 0xF) + 1);
            dateTime = dateTime.withDayOfMonth(p >>> 5 & 0x1F);
            dateTime = dateTime.withHourOfDay(p & 0x1F);
            dateTime = dateTime.withMinuteOfHour(s >>> 26 & 0x3F);
            dateTime = dateTime.withSecondOfMinute(s >>> 20 & 0x3F);
            dateTime = dateTime.withMillisOfSecond((s & 0xFFFFF) / 1000);
        }
        if (!utc) {
            dateTime = dateTime.toDateTime(DateTimeZone.getDefault());
        }
        return dateTime;
    }

    private static byte[] mdump(DateTime dateTime, long nanoSeconds) {
        byte[] dumpValue = new byte[8];
        long usec = nanoSeconds / 1000L;
        DateTime dt = dateTime;
        boolean isUTC = true;
        if (dt.getZone() != DateTimeZone.UTC) {
            if (dt.getZone().equals((Object)DateTimeZone.getDefault())) {
                isUTC = false;
            }
            dt = dt.toDateTime(DateTimeZone.UTC);
        }
        int pe = Integer.MIN_VALUE | (isUTC ? 1 : 0) << 30 | dt.getYear() - 1900 << 14 | dt.getMonthOfYear() - 1 << 10 | dt.getDayOfMonth() << 5 | dt.getHourOfDay();
        int se = dt.getMinuteOfHour() << 26 | dt.getSecondOfMinute() << 20 | dt.getMillisOfSecond() * 1000 + (int)usec;
        int i = 0;
        while (i < 4) {
            dumpValue[i] = (byte)(pe & 0xFF);
            pe >>>= 8;
            ++i;
        }
        i = 4;
        while (i < 8) {
            dumpValue[i] = (byte)(se & 0xFF);
            se >>>= 8;
            ++i;
        }
        return dumpValue;
    }

    public DateTime getDateTime() {
        return Time.mload((byte[])this.getData());
    }

    @Override
    public byte[] marshalDump() {
        return (byte[])this.getData();
    }

    @Override
    public void marshalLoad(byte[] data) throws IOException {
        this.setData(data);
    }

    @Override
    public String toString() {
        return this.getDateTime().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTime time = ((Time)o).getDateTime();
        return this.getDateTime().equals((Object)time);
    }

    @Override
    public int hashCode() {
        return this.getDateTime().hashCode();
    }
}

