/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.api;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.sonatype.nexus.hazelcast.api.NodeXO;
import com.sonatype.nexus.hazelcast.api.NodesResourceDoc;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.node.NodeConfigurationSource;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/nodes")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NodesResource
extends ComponentSupport
implements Resource,
NodesResourceDoc {
    public static final String RESOURCE_URI = "/v1/nodes";
    static final String NODE_IDENTITY = "node.identity";
    private final Provider<HazelcastInstance> hazelcastProvider;
    private final NodeAccess nodeAccess;
    private final NodeConfigurationSource nodeConfigurationSource;

    @Inject
    public NodesResource(Provider<HazelcastInstance> hazelcastProvider, NodeAccess nodeAccess, NodeConfigurationSource nodeConfigurationSource) {
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.nodeConfigurationSource = (NodeConfigurationSource)Preconditions.checkNotNull((Object)nodeConfigurationSource);
    }

    @Override
    @GET
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:nodes:read"})
    public List<NodeXO> get() {
        if (this.nodeAccess.isClustered()) {
            return ((HazelcastInstance)this.hazelcastProvider.get()).getCluster().getMembers().stream().map(this::memberToNode).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    @PUT
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:nodes:update"})
    public NodeXO update(@NotNull @Valid NodeXO nodeXO) {
        if (this.nodeAccess.isClustered()) {
            if (!this.memberExists(nodeXO.getNodeIdentity())) {
                throw new WebApplicationException(String.format("no node found with identity '%s'", nodeXO.getNodeIdentity()), Response.Status.NOT_FOUND);
            }
            this.log.debug("updating node {} to have friendly name: {}", (Object)nodeXO.getNodeIdentity(), (Object)nodeXO.getFriendlyName());
            if (nodeXO.getFriendlyName() != null) {
                this.nodeConfigurationSource.setFriendlyName(nodeXO.getNodeIdentity(), nodeXO.getFriendlyName());
            } else {
                this.nodeConfigurationSource.delete(nodeXO.getNodeIdentity());
            }
            return this.memberToNode(((HazelcastInstance)this.hazelcastProvider.get()).getCluster().getMembers().stream().filter(m -> nodeXO.getNodeIdentity().equals(m.getStringAttribute(NODE_IDENTITY))).findAny().orElse(null));
        }
        throw new WebApplicationException("HA-C is not enabled", Response.Status.BAD_REQUEST);
    }

    @Nullable
    protected NodeXO memberToNode(@Nullable Member member) {
        if (member == null) {
            return null;
        }
        String nodeId = member.getStringAttribute(NODE_IDENTITY);
        NodeXO node = new NodeXO();
        node.setNodeIdentity(nodeId);
        node.setSocketAddress(member.getSocketAddress().toString());
        this.nodeConfigurationSource.getById(nodeId).ifPresent(config -> node.setFriendlyName(config.getFriendlyNodeName()));
        return node;
    }

    private boolean memberExists(@Nullable String nodeIdentity) {
        if (nodeIdentity == null) {
            return false;
        }
        return ((HazelcastInstance)this.hazelcastProvider.get()).getCluster().getMembers().stream().anyMatch(m -> nodeIdentity.equals(m.getStringAttribute(NODE_IDENTITY)));
    }
}

