/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal;

import com.google.common.base.Preconditions;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.HazelcastInstance;
import javax.annotation.PreDestroy;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;

@Named(value="hazelcast")
@Singleton
public class HazelcastCacheManagerProvider
extends ComponentSupport
implements Provider<CacheManager> {
    private volatile CacheManager cacheManager;

    @Inject
    public HazelcastCacheManagerProvider(HazelcastInstance hazelcastInstance) {
        Preconditions.checkNotNull((Object)hazelcastInstance);
        HazelcastServerCachingProvider cachingProvider = new HazelcastServerCachingProvider();
        this.cacheManager = new HazelcastServerCacheManager(cachingProvider, hazelcastInstance, null, null, null){

            protected <K, V, C extends Configuration<K, V>> CacheConfig<K, V> createCacheConfig(String cacheName, C configuration) {
                return new CacheConfigWrapper(super.createCacheConfig(cacheName, configuration), this.getHazelcastInstance().getConfig().getClassLoader());
            }
        };
    }

    public CacheManager get() {
        Preconditions.checkState((this.cacheManager != null ? 1 : 0) != 0, (Object)"Cache-manager destroyed");
        return this.cacheManager;
    }

    @PreDestroy
    public void destroy() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
            this.log.info("Cache-manager closed");
            this.cacheManager = null;
        }
    }

    private static class CacheConfigWrapper<K, V>
    extends CacheConfig<K, V> {
        public CacheConfigWrapper(CacheConfig<K, V> config, ClassLoader classLoader) {
            super(config);
            this.setClassLoader(classLoader);
        }
    }
}

