/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal;

import com.google.common.base.Preconditions;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.sonatype.nexus.hazelcast.HazelcastConfigCustomizer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.node.NodeAccess;

@Named(value="nexus")
@Singleton
public class HazelcastInstanceProvider
extends ComponentSupport
implements Provider<HazelcastInstance> {
    public static final String INSTANCE_NAME = "nexus";
    private static final String WARNING_HEADER = "WARNING: ****************************************************************************";
    private static final String WARNING_VIOLATION = "WARNING: High availability requires a Nexus Repository Manager Professional license.";
    private final BundleContext bundleContext;
    private final ApplicationDirectories directories;
    private final NodeAccess nodeAccess;
    private final List<HazelcastConfigCustomizer> configCustomizers;
    private final ClassLoader uberClassLoader;
    private final Provider<ApplicationLicense> applicationLicenseProvider;
    private HazelcastInstance instance;
    private ServiceRegistration<?> registration;

    @Inject
    public HazelcastInstanceProvider(BundleContext bundleContext, ApplicationDirectories directories, NodeAccess nodeAccess, List<HazelcastConfigCustomizer> configCustomizers, @Named(value="nexus-uber") ClassLoader uberClassLoader, Provider<ApplicationLicense> applicationLicenseProvider) {
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.configCustomizers = (List)Preconditions.checkNotNull(configCustomizers);
        this.uberClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)uberClassLoader);
        this.applicationLicenseProvider = (Provider)Preconditions.checkNotNull(applicationLicenseProvider);
    }

    public HazelcastInstance get() {
        Preconditions.checkState((boolean)this.nodeAccess.isClustered(), (Object)"Clustering is not enabled");
        this.checkLicense();
        this.instance = Hazelcast.newHazelcastInstance((Config)this.getHazelcastConfig());
        this.log.info("Instance: {}", (Object)this.instance);
        this.registration = this.bundleContext.registerService(HazelcastInstance.class, (Object)this.instance, null);
        return this.instance;
    }

    @PreDestroy
    public void shutdown() {
        if (this.instance != null) {
            this.log.info("Shutting down: {}", (Object)this.instance);
            try {
                try {
                    this.registration.unregister();
                }
                catch (IllegalStateException e) {
                    this.log.trace("bundle has already been stopped and the service unregistered", (Throwable)e);
                    this.registration = null;
                    this.instance.shutdown();
                    this.instance = null;
                }
            }
            finally {
                this.registration = null;
                this.instance.shutdown();
                this.instance = null;
            }
        }
    }

    private Config getHazelcastConfig() {
        Config config;
        block12: {
            this.maybeCopyDefaults();
            File file = new File(this.directories.getConfigDirectory("fabric"), "hazelcast.xml");
            if (file.exists()) {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                        config = new XmlConfigBuilder((InputStream)in).build();
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.log.warn("Missing configuration: {}; using defaults", (Object)file.getAbsolutePath());
            config = new XmlConfigBuilder().build();
        }
        this.configCustomizers.forEach(it -> it.apply(config));
        config.setInstanceName(INSTANCE_NAME);
        config.setClassLoader(this.uberClassLoader);
        this.log.debug("Config: {}", (Object)config);
        return config;
    }

    private void maybeCopyDefaults() {
        File customFile = new File(this.directories.getWorkDirectory("etc/fabric"), "hazelcast-network.xml");
        if (!customFile.exists()) {
            File templateFile = new File(this.directories.getConfigDirectory("fabric"), "hazelcast-network-default.xml");
            this.copyDefaults(templateFile, customFile);
        }
    }

    private void copyDefaults(File from, File to) {
        this.log.info("Initializing default Hazelcast configuration {}", (Object)to);
        try {
            Files.write(to.toPath(), (Iterable<? extends CharSequence>)Files.readAllLines(from.toPath()).stream().filter(line -> !line.startsWith("<!--#") || !line.endsWith("#-->")).collect(Collectors.toList()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create configuration file " + to, e);
        }
    }

    private void checkLicense() {
        ApplicationLicense applicationLicense = (ApplicationLicense)this.applicationLicenseProvider.get();
        if (!applicationLicense.isValid()) {
            this.log.warn(WARNING_HEADER);
            this.log.warn(WARNING_VIOLATION);
            this.log.warn(WARNING_HEADER);
        }
    }
}

