/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.node.NodeConfiguration;
import org.sonatype.nexus.common.node.NodeConfigurationSource;
import org.sonatype.nexus.common.property.PropertiesFile;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class PropertiesNodeConfigurationSource
extends StateGuardLifecycleSupport
implements NodeConfigurationSource,
Lifecycle,
ItemListener<NodeConfiguration> {
    @VisibleForTesting
    static final String NODE_NAME_KEY = "nexus.clustered.nodeName";
    private final NodeAccess nodeAccess;
    private final ApplicationDirectories applicationDirectories;
    private final HazelcastInstance hazelcastInstance;
    private Set<NodeConfiguration> nodeConfigurations;
    private String myFriendlyName;
    private static final Lock PROPERTY_UPDATE_LOCK = new ReentrantLock();

    @Inject
    public PropertiesNodeConfigurationSource(NodeAccess nodeAccess, ApplicationDirectories applicationDirectories) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.hazelcastInstance = Hazelcast.getHazelcastInstanceByName((String)"nexus");
    }

    @VisibleForTesting
    PropertiesNodeConfigurationSource(NodeAccess nodeAccess, ApplicationDirectories applicationDirectories, HazelcastInstance hazelcastInstance) {
        this.nodeAccess = nodeAccess;
        this.applicationDirectories = applicationDirectories;
        this.hazelcastInstance = hazelcastInstance;
    }

    protected void doStart() throws Exception {
        if (this.nodeAccess.isClustered()) {
            if (this.hazelcastInstance.getConfig().getSetConfigs().containsKey(NODE_NAME_KEY)) {
                this.nodeConfigurations = this.hazelcastInstance.getSet(NODE_NAME_KEY);
            } else {
                this.hazelcastInstance.getConfig().getSetConfig(NODE_NAME_KEY).setBackupCount(1);
                this.nodeConfigurations = this.hazelcastInstance.getSet(NODE_NAME_KEY);
            }
            if (System.getProperties().containsKey(NODE_NAME_KEY)) {
                this.myFriendlyName = System.getProperty(NODE_NAME_KEY);
                this.findById(this.nodeAccess.getId()).ifPresent(this.nodeConfigurations::remove);
                this.nodeConfigurations.add(new NodeConfiguration(this.nodeAccess.getId(), this.myFriendlyName));
            } else {
                this.findById(this.nodeAccess.getId()).ifPresent(this.nodeConfigurations::remove);
            }
            ((ISet)this.nodeConfigurations).addItemListener((ItemListener)this, true);
        } else {
            this.nodeConfigurations = Collections.EMPTY_SET;
            this.myFriendlyName = "";
        }
    }

    @Guarded(by={"STARTED"})
    public List<NodeConfiguration> loadAll() {
        return ImmutableList.copyOf(this.nodeConfigurations);
    }

    @Guarded(by={"STARTED"})
    public Optional<NodeConfiguration> getById(String nodeId) {
        if (Strings2.isEmpty((String)nodeId)) {
            return Optional.empty();
        }
        return this.findById(nodeId);
    }

    @Guarded(by={"STARTED"})
    public String create(NodeConfiguration configuration) {
        this.nodeConfigurations.add(configuration);
        return configuration.getId();
    }

    @Guarded(by={"STARTED"})
    public boolean update(NodeConfiguration configuration) {
        this.findById(configuration.getId()).ifPresent(config -> {
            boolean bl = this.nodeConfigurations.remove(config);
        });
        this.nodeConfigurations.add(configuration);
        return true;
    }

    @Guarded(by={"STARTED"})
    public boolean delete(String nodeId) {
        AtomicBoolean removed = new AtomicBoolean(Boolean.FALSE);
        this.findById(nodeId).ifPresent(found -> removed.set(this.nodeConfigurations.remove(found)));
        return removed.get();
    }

    @Guarded(by={"STARTED"})
    public void setFriendlyName(String nodeId, String friendlyName) {
        Optional<NodeConfiguration> found = this.findById(nodeId);
        if (found.isPresent()) {
            this.update(new NodeConfiguration(nodeId, friendlyName));
        } else {
            this.create(new NodeConfiguration(nodeId, friendlyName));
        }
    }

    @Guarded(by={"STARTED"})
    public String sayMyName() {
        return this.myFriendlyName;
    }

    public void itemAdded(ItemEvent<NodeConfiguration> event) {
        this.updateNexusPropertiesFile(event, (nodeConfig, file) -> {
            this.myFriendlyName = nodeConfig.getFriendlyNodeName();
            if (!Objects.equals(this.myFriendlyName, System.getProperty(NODE_NAME_KEY))) {
                System.setProperty(NODE_NAME_KEY, this.myFriendlyName);
                file.setProperty(NODE_NAME_KEY, this.myFriendlyName);
            }
        });
    }

    public void itemRemoved(ItemEvent<NodeConfiguration> event) {
        this.updateNexusPropertiesFile(event, (nodeConfig, file) -> {
            this.myFriendlyName = null;
            System.clearProperty(NODE_NAME_KEY);
            file.remove((Object)NODE_NAME_KEY);
        });
    }

    private void updateNexusPropertiesFile(ItemEvent<NodeConfiguration> event, BiConsumer<NodeConfiguration, PropertiesFile> consumer) {
        NodeConfiguration eventItem = (NodeConfiguration)event.getItem();
        if (Objects.equals(this.nodeAccess.getId(), eventItem.getId())) {
            PROPERTY_UPDATE_LOCK.lock();
            try {
                try {
                    File nodeNameProps = new File(this.applicationDirectories.getWorkDirectory(), "etc/node-name.properties");
                    if (!nodeNameProps.exists() && !nodeNameProps.createNewFile()) {
                        throw new IOException(String.format("failed to create file: %s", nodeNameProps.getAbsolutePath()));
                    }
                    PropertiesFile file = new PropertiesFile(nodeNameProps);
                    file.load();
                    consumer.accept(eventItem, file);
                    file.store();
                }
                catch (IOException e) {
                    this.log.warn("failed to remove the friendly node name from the properties file", (Throwable)e);
                    PROPERTY_UPDATE_LOCK.unlock();
                }
            }
            finally {
                PROPERTY_UPDATE_LOCK.unlock();
            }
        }
    }

    private Optional<NodeConfiguration> findById(String nodeId) {
        return this.nodeConfigurations.stream().filter(node -> Objects.equals(nodeId, node.getId())).findFirst();
    }
}

