/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.cache;

import com.google.common.base.Preconditions;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import java.io.Serializable;
import java.util.function.BiConsumer;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cache.AbstractCacheBuilder;

@Named(value="hazelcast")
public class HazelcastCacheBuilder<K, V>
extends AbstractCacheBuilder<K, V> {
    public Cache<K, V> build(CacheManager manager) {
        Preconditions.checkNotNull((Object)manager);
        Preconditions.checkNotNull((Object)this.keyType);
        Preconditions.checkNotNull((Object)this.valueType);
        Preconditions.checkNotNull((Object)this.name);
        Preconditions.checkNotNull((Object)this.expiryFactory);
        EvictionConfig evictionConfig = new EvictionConfig(this.cacheSize, EvictionConfig.MaxSizePolicy.ENTRY_COUNT, EvictionPolicy.LRU);
        CacheConfig config = new CacheConfig();
        config.setEvictionConfig(evictionConfig);
        config.setExpiryPolicyFactory(this.expiryFactory);
        config.setStoreByValue(this.storeByValue);
        config.setManagementEnabled(this.managementEnabled);
        config.setStatisticsEnabled(this.statisticsEnabled);
        config.setKeyType(this.keyType);
        config.setValueType(this.valueType);
        if (this.persister != null) {
            CacheRemovalListenter listener = new CacheRemovalListenter(this.persister);
            FactoryBuilder.SingletonFactory listenerFactory = new FactoryBuilder.SingletonFactory(listener);
            MutableCacheEntryListenerConfiguration listenerConfig = new MutableCacheEntryListenerConfiguration((Factory)listenerFactory, null, true, false);
            config.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfig);
        }
        Cache cache = manager.createCache(this.name, (Configuration)config);
        return cache;
    }

    private static class CacheRemovalListenter<K, V>
    extends ComponentSupport
    implements CacheEntryExpiredListener<K, V>,
    CacheEntryRemovedListener<K, V>,
    Serializable {
        private final BiConsumer<K, V> persister;

        private CacheRemovalListenter(BiConsumer<K, V> persister) {
            this.persister = persister;
        }

        public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            events.forEach(event -> this.persister.accept(event.getKey(), event.getValue()));
        }

        public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
            events.forEach(event -> this.persister.accept(event.getKey(), event.getValue()));
        }
    }
}

