/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.ldap;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.sonatype.nexus.hazelcast.internal.HazelcastDistributorSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.ldap.persist.LdapCacheInvalidatedEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationManager;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class HazelcastLdapDistributor
extends HazelcastDistributorSupport
implements EventAware,
MessageListener<String> {
    static final String CACHE_INVALIDATED = "LdapCacheInvalidatedEvent";
    private final LdapConfigurationManager ldapConfigurationManager;
    private final Provider<HazelcastInstance> hazelcastProvider;
    private ITopic<String> topic;
    private String messageListenerId;

    @Inject
    public HazelcastLdapDistributor(LdapConfigurationManager ldapConfigurationManager, Provider<HazelcastInstance> hazelcastProvider, NodeAccess nodeAccess) {
        super(nodeAccess);
        this.ldapConfigurationManager = (LdapConfigurationManager)Preconditions.checkNotNull((Object)ldapConfigurationManager);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
    }

    @Override
    protected void doStartCluster() throws Exception {
        this.topic = ((HazelcastInstance)this.hazelcastProvider.get()).getTopic("nexus:ldap");
        this.messageListenerId = this.topic.addMessageListener((MessageListener)this);
    }

    @Override
    protected void doStopCluster() throws Exception {
        this.topic.removeMessageListener(this.messageListenerId);
    }

    @Subscribe
    public void on(LdapCacheInvalidatedEvent event) {
        if (!this.isClustered() || this.isRunningAsRemote()) {
            return;
        }
        this.log.debug("Distributing {} to other nodes of cluster", (Object)event);
        this.topic.publish((Object)CACHE_INVALIDATED);
    }

    public void onMessage(Message<String> message) {
        if (!message.getPublishingMember().localMember()) {
            String msg = (String)message.getMessageObject();
            this.log.debug("Receiving {} from remote node {}", (Object)msg, (Object)message.getPublishingMember());
            this.runAsRemote(() -> {
                switch (msg) {
                    case "LdapCacheInvalidatedEvent": {
                        this.ldapConfigurationManager.clearCache();
                        break;
                    }
                }
            });
        }
    }
}

