/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.licensing;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.sonatype.nexus.hazelcast.internal.HazelcastDistributorSupport;
import com.sonatype.nexus.licensing.ext.LicenseChangedEvent;
import com.sonatype.nexus.licensing.ext.LicenseManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.node.NodeAccess;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class HazelcastLicenseDistributor
extends HazelcastDistributorSupport
implements EventAware,
MessageListener<byte[]> {
    private final LicenseManager licenseManager;
    private final Provider<HazelcastInstance> hazelcastProvider;
    private volatile boolean licenseInitialized;
    private ITopic<byte[]> topic;
    private IAtomicReference<byte[]> sharedLicense;
    private String messageListenerId;

    @Inject
    public HazelcastLicenseDistributor(LicenseManager licenseManager, Provider<HazelcastInstance> hazelcastProvider, NodeAccess nodeAccess) {
        super(nodeAccess);
        this.licenseManager = (LicenseManager)Preconditions.checkNotNull((Object)licenseManager);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
    }

    @Override
    protected void doStartCluster() throws Exception {
        this.topic = ((HazelcastInstance)this.hazelcastProvider.get()).getTopic("nexus:license");
        this.messageListenerId = this.topic.addMessageListener((MessageListener)this);
        this.sharedLicense = ((HazelcastInstance)this.hazelcastProvider.get()).getAtomicReference("nexus:sharedLicense");
        byte[] localLicenseFile = this.licenseManager.getLicenseFile();
        byte[] clusterLicenseFile = (byte[])this.sharedLicense.get();
        if (localLicenseFile == null && clusterLicenseFile != null) {
            this.log.info("No license installed on this node: installing cluster license");
            this.licenseManager.installLicense(clusterLicenseFile);
        } else if (localLicenseFile != null && clusterLicenseFile == null) {
            this.log.info("Cluster license has not been initialized: setting it to the license of this node");
            this.sharedLicense.set((Object)localLicenseFile);
        }
    }

    @Override
    protected void doStopCluster() throws Exception {
        this.topic.removeMessageListener(this.messageListenerId);
    }

    @Subscribe
    public void onLicenseChange(LicenseChangedEvent event) {
        if (!this.licenseInitialized) {
            this.log.debug("Node booted and initialized license");
            this.licenseInitialized = true;
            return;
        }
        if (!this.isClustered() || this.isRunningAsRemote()) {
            return;
        }
        if (!event.isLicenseValid()) {
            this.log.debug("Not distributing invalid license to other nodes of cluster");
            return;
        }
        this.log.debug("Distributing valid license to other nodes of cluster");
        byte[] licenseFile = this.licenseManager.getLicenseFile();
        Preconditions.checkState((licenseFile != null ? 1 : 0) != 0, (Object)"no license file installed");
        this.topic.publish((Object)licenseFile);
        this.sharedLicense.set((Object)licenseFile);
    }

    public void onMessage(Message<byte[]> message) {
        if (!message.getPublishingMember().localMember()) {
            this.log.debug("Installing license from remote node {}", (Object)message.getPublishingMember());
            this.runAsRemote(() -> {
                try {
                    this.licenseManager.installLicense((byte[])message.getMessageObject());
                }
                catch (Exception e) {
                    this.log.error("Failed to update license received from remote node {}", (Object)message.getPublishingMember(), (Object)e);
                }
            });
        }
    }
}

