/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.log;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.sonatype.nexus.hazelcast.internal.HazelcastDistributorSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.log.LogMarkInsertedEvent;
import org.sonatype.nexus.common.log.LogMarker;
import org.sonatype.nexus.common.node.NodeAccess;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class HazelcastLogMarkDistributor
extends HazelcastDistributorSupport
implements EventAware,
MessageListener<String> {
    private final LogMarker logMarker;
    private final Provider<HazelcastInstance> hazelcastProvider;
    private ITopic<String> topic;
    private String messageListenerId;

    @Inject
    public HazelcastLogMarkDistributor(LogMarker logMarker, Provider<HazelcastInstance> hazelcastProvider, NodeAccess nodeAccess) {
        super(nodeAccess);
        this.logMarker = (LogMarker)Preconditions.checkNotNull((Object)logMarker);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
    }

    @Override
    protected void doStartCluster() throws Exception {
        this.topic = ((HazelcastInstance)this.hazelcastProvider.get()).getTopic("nexus:log:mark");
        this.messageListenerId = this.topic.addMessageListener((MessageListener)this);
    }

    @Override
    protected void doStopCluster() throws Exception {
        this.topic.removeMessageListener(this.messageListenerId);
    }

    @Subscribe
    public void onLogMarked(LogMarkInsertedEvent event) {
        if (!this.isClustered() || this.isRunningAsRemote()) {
            return;
        }
        this.log.debug("Distributing log mark to other nodes of cluster");
        this.topic.publish((Object)event.getMessage());
    }

    public void onMessage(Message<String> message) {
        if (!message.getPublishingMember().localMember()) {
            this.log.debug("Marking log from remote node {}", (Object)message.getPublishingMember());
            this.runAsRemote(() -> this.logMarker.markLog((String)message.getMessageObject()));
        }
    }
}

