/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapClearedListener;
import com.hazelcast.map.listener.MapListener;
import com.sonatype.nexus.hazelcast.internal.HazelcastDistributorSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.log.LogManager;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.common.log.LoggerLevelChangedEvent;
import org.sonatype.nexus.common.log.LoggersResetEvent;
import org.sonatype.nexus.common.node.NodeAccess;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class HazelcastLoggerConfigurationDistributor
extends HazelcastDistributorSupport
implements EventAware,
EntryAddedListener<String, String>,
EntryRemovedListener<String, String>,
EntryUpdatedListener<String, String>,
MapClearedListener {
    @VisibleForTesting
    static final String DISTRIBUTED_OVERRIDDEN_CONFIG = "nexus:logger-level-map";
    private IMap<String, String> loggerNameLevelMap;
    private String entryListenerId;
    private final Provider<HazelcastInstance> hazelcastProvider;
    private final LogManager logManager;

    @Inject
    public HazelcastLoggerConfigurationDistributor(Provider<HazelcastInstance> hazelcastProvider, LogManager logManager, NodeAccess nodeAccess) {
        super(nodeAccess);
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
    }

    @Override
    protected void doStartCluster() throws Exception {
        HazelcastInstance hazelcastInstance = (HazelcastInstance)this.hazelcastProvider.get();
        this.loggerNameLevelMap = hazelcastInstance.getMap(DISTRIBUTED_OVERRIDDEN_CONFIG);
        if (((Member)hazelcastInstance.getCluster().getMembers().iterator().next()).localMember()) {
            this.log.debug("Initializing distributed map with local logging configuration");
            this.logManager.getOverriddenLoggers().forEach((key, value) -> {
                Object object = this.loggerNameLevelMap.put(key, (Object)value.name());
            });
        } else {
            this.log.debug("Initializing local logging configuration from distributed map");
            this.runAsRemote(() -> {
                this.logManager.resetLoggers();
                this.loggerNameLevelMap.forEach((key, value) -> this.logManager.setLoggerLevel(key, LoggerLevel.valueOf((String)value)));
            });
        }
        this.entryListenerId = this.loggerNameLevelMap.addEntryListener((MapListener)this, true);
    }

    @Override
    protected void doStopCluster() throws Exception {
        this.loggerNameLevelMap.removeEntryListener(this.entryListenerId);
    }

    public void entryAdded(EntryEvent<String, String> entryEvent) {
        this.setLoggerLevel(entryEvent);
    }

    public void entryUpdated(EntryEvent<String, String> entryEvent) {
        this.setLoggerLevel(entryEvent);
    }

    public void entryRemoved(EntryEvent<String, String> entryEvent) {
        this.unsetLoggerLevel(entryEvent);
    }

    public void mapCleared(MapEvent mapEvent) {
        this.resetLoggers(mapEvent);
    }

    @Subscribe
    public void onLoggerLevelChanged(LoggerLevelChangedEvent event) {
        if (!this.isClustered() || this.isRunningAsRemote()) {
            return;
        }
        this.log.debug("Adding new logger entry to distributed map {}:{}", (Object)event.getLogger(), (Object)event.getLevel());
        if (event.getLevel() == null) {
            this.loggerNameLevelMap.remove((Object)event.getLogger());
        } else {
            this.loggerNameLevelMap.put((Object)event.getLogger(), (Object)event.getLevel().name());
        }
    }

    @Subscribe
    public void onLoggersReset(LoggersResetEvent event) {
        if (!this.isClustered() || this.isRunningAsRemote()) {
            return;
        }
        this.log.debug("Clearing distributed map");
        this.loggerNameLevelMap.clear();
    }

    private void setLoggerLevel(EntryEvent<String, String> entryEvent) {
        if (!entryEvent.getMember().localMember()) {
            this.runAsRemote(() -> this.logManager.setLoggerLevel((String)entryEvent.getKey(), LoggerLevel.valueOf((String)((String)entryEvent.getValue()))));
        }
    }

    private void unsetLoggerLevel(EntryEvent<String, String> entryEvent) {
        if (!entryEvent.getMember().localMember()) {
            this.runAsRemote(() -> this.logManager.unsetLoggerLevel((String)entryEvent.getKey()));
        }
    }

    private void resetLoggers(MapEvent mapEvent) {
        if (!mapEvent.getMember().localMember()) {
            this.runAsRemote(() -> this.logManager.resetLoggers());
        }
    }
}

