/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.sonatype.nexus.hazelcast.internal.orient.SharedHazelcastPlugin;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.DatabaseServer;
import org.sonatype.nexus.orient.quorum.DatabaseQuorumResetEvent;
import org.sonatype.nexus.orient.quorum.DatabaseQuorumService;
import org.sonatype.nexus.orient.quorum.DatabaseQuorumStatus;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Singleton
public class DatabaseQuorumServiceImpl
extends ComponentSupport
implements DatabaseQuorumService {
    private final Provider<OServer> serverProvider;
    private final DatabaseServer databaseServer;
    private final NodeAccess nodeAccess;
    private final EventManager eventManager;

    @Inject
    public DatabaseQuorumServiceImpl(Provider<OServer> serverProvider, DatabaseServer databaseServer, NodeAccess nodeAccess, EventManager eventManager) {
        this.serverProvider = (Provider)Preconditions.checkNotNull(serverProvider);
        this.databaseServer = (DatabaseServer)Preconditions.checkNotNull((Object)databaseServer);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    public DatabaseQuorumStatus getQuorumStatus() {
        DatabaseQuorumStatus status = DatabaseQuorumStatus.singleNode();
        if (!this.nodeAccess.isClustered()) {
            return status;
        }
        for (String databaseName : this.databaseServer.databases()) {
            status = this.getQuorumStatus(databaseName);
            if (status.isQuorumPresent()) continue;
            return status;
        }
        return status;
    }

    public DatabaseQuorumStatus getQuorumStatus(String databaseName) {
        Preconditions.checkNotNull((Object)databaseName);
        Preconditions.checkArgument((boolean)this.databaseServer.databases().contains(databaseName));
        if (!this.nodeAccess.isClustered()) {
            return DatabaseQuorumStatus.singleNode();
        }
        ODistributedServerManager serverManager = ((OServer)this.serverProvider.get()).getDistributedManager();
        List onlineNodes = serverManager.getOnlineNodes(databaseName);
        ODistributedConfiguration configuration = serverManager.getDatabaseConfiguration(databaseName);
        Set members = configuration.getAllConfiguredServers();
        int writeQuorum = configuration.getWriteQuorum(null, members.size(), null);
        return new DatabaseQuorumStatus((Collection)onlineNodes, writeQuorum, databaseName, (Collection)members);
    }

    public void resetWriteQuorum() {
        ODistributedServerManager distributedServerManager = ((OServer)this.serverProvider.get()).getDistributedManager();
        if (distributedServerManager == null || !this.nodeAccess.isClustered()) {
            this.log.info("Cannot reset write quorum for non-clustered database");
            return;
        }
        this.log.info("Resetting write quorum by removing all nodes except {}", (Object)this.nodeAccess.getId());
        SharedHazelcastPlugin hazelcastPlugin = (SharedHazelcastPlugin)((OServer)this.serverProvider.get()).getPluginByClass(SharedHazelcastPlugin.class);
        hazelcastPlugin.resetWriteQuorum();
        this.log.info("Write quorum has been reset");
        this.eventManager.post((Object)new DatabaseQuorumResetEvent());
    }
}

