/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.sonatype.nexus.hazelcast.internal.HazelcastDistributorSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeChangeEvent;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
public class HazelcastDatabaseFreezeDistributor
extends HazelcastDistributorSupport
implements EventAware,
MessageListener<Boolean> {
    public static final String TOPIC_NAME = "nexus:freeze-database";
    private final DatabaseFreezeService databaseFreezeService;
    private final Provider<HazelcastInstance> hazelcastInstanceProvider;
    @VisibleForTesting
    String messageListenerId;
    @VisibleForTesting
    ITopic<Boolean> freezeTopic;

    @Inject
    public HazelcastDatabaseFreezeDistributor(NodeAccess nodeAccess, DatabaseFreezeService databaseFreezeService, Provider<HazelcastInstance> hazelcastInstanceProvider) {
        super(nodeAccess);
        this.databaseFreezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)databaseFreezeService);
        this.hazelcastInstanceProvider = (Provider)Preconditions.checkNotNull(hazelcastInstanceProvider);
    }

    @Override
    protected void doStartCluster() throws Exception {
        this.freezeTopic = ((HazelcastInstance)this.hazelcastInstanceProvider.get()).getTopic(TOPIC_NAME);
        this.messageListenerId = this.freezeTopic.addMessageListener((MessageListener)this);
    }

    @Override
    protected void doStopCluster() throws Exception {
        if (this.messageListenerId != null) {
            this.freezeTopic.removeMessageListener(this.messageListenerId);
        }
    }

    @Subscribe
    public void onDatabaseFreezeChangeEvent(DatabaseFreezeChangeEvent databaseFreezeChangeEvent) {
        if (this.freezeTopic != null) {
            this.log.debug("publishing {}", (Object)databaseFreezeChangeEvent);
            this.freezeTopic.publish((Object)databaseFreezeChangeEvent.isFrozen());
        }
    }

    public void onMessage(Message<Boolean> message) {
        Boolean distributedFreezeMessage = (Boolean)message.getMessageObject();
        Preconditions.checkNotNull((Object)distributedFreezeMessage, (Object)String.format("Expecting a boolean onDatabaseFreezeChangeEvent hazelcast topic %s, but got null", TOPIC_NAME));
        if (!message.getPublishingMember().localMember()) {
            boolean localFrozenState = this.databaseFreezeService.isFrozen();
            this.log.info("Received distributedFreezeMessage={} from another node on {}; local frozen state= {}", new Object[]{distributedFreezeMessage, TOPIC_NAME, localFrozenState});
            if (distributedFreezeMessage.booleanValue() && !localFrozenState) {
                this.databaseFreezeService.freezeLocalDatabases();
            } else if (!distributedFreezeMessage.booleanValue() && localFrozenState) {
                this.databaseFreezeService.releaseLocalDatabases();
            } else {
                this.log.info("No changes to local frozen state required");
            }
        }
    }
}

