/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.freeze.DatabaseFrozenStateManager;
import org.sonatype.nexus.orient.freeze.FreezeRequest;

@Named(value="hazelcast")
@Singleton
@Priority(value=0x7FFFFFFF)
public class HazelcastDatabaseFrozenStateManager
extends ComponentSupport
implements DatabaseFrozenStateManager {
    @VisibleForTesting
    static final String DISTRIBUTED_STATE_NAME = "nexus:frozen";
    private final NodeAccess nodeAccess;
    private final DatabaseFrozenStateManager localDatabaseFrozenStateManager;
    private final Provider<HazelcastInstance> hazelcastInstanceProvider;

    @Inject
    public HazelcastDatabaseFrozenStateManager(NodeAccess nodeAccess, @Named(value="local") DatabaseFrozenStateManager localDatabaseFrozenStateManager, Provider<HazelcastInstance> hazelcastInstanceProvider) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.localDatabaseFrozenStateManager = (DatabaseFrozenStateManager)Preconditions.checkNotNull((Object)localDatabaseFrozenStateManager);
        this.hazelcastInstanceProvider = (Provider)Preconditions.checkNotNull(hazelcastInstanceProvider);
    }

    public List<FreezeRequest> getState() {
        if (this.nodeAccess.isClustered()) {
            IList list = ((HazelcastInstance)this.hazelcastInstanceProvider.get()).getList(DISTRIBUTED_STATE_NAME);
            return list.stream().map(r -> r.getFreezeRequest()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return this.localDatabaseFrozenStateManager.getState();
    }

    public boolean remove(FreezeRequest request) {
        if (this.nodeAccess.isClustered()) {
            IList list = ((HazelcastInstance)this.hazelcastInstanceProvider.get()).getList(DISTRIBUTED_STATE_NAME);
            return list.remove(new SerializableFreezeRequest(request));
        }
        return this.localDatabaseFrozenStateManager.remove(request);
    }

    public FreezeRequest add(FreezeRequest request) {
        if (this.nodeAccess.isClustered()) {
            IList list = ((HazelcastInstance)this.hazelcastInstanceProvider.get()).getList(DISTRIBUTED_STATE_NAME);
            if (list.add(new SerializableFreezeRequest(request))) {
                return request;
            }
            return null;
        }
        return this.localDatabaseFrozenStateManager.add(request);
    }

    static class SerializableFreezeRequest
    implements DataSerializable {
        private FreezeRequest freezeRequest;

        SerializableFreezeRequest() {
        }

        SerializableFreezeRequest(FreezeRequest freezeRequest) {
            this.freezeRequest = (FreezeRequest)Preconditions.checkNotNull((Object)freezeRequest);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.freezeRequest.getInitiatorType().name());
            out.writeUTF(this.freezeRequest.getInitiatorId());
            out.writeLong(this.freezeRequest.getTimestamp().toDateTime().getMillis());
        }

        public void readData(ObjectDataInput in) throws IOException {
            FreezeRequest.InitiatorType type = FreezeRequest.InitiatorType.valueOf((String)in.readUTF());
            String id = in.readUTF();
            DateTime timestamp = new DateTime(in.readLong());
            this.freezeRequest = new FreezeRequest(type, id, timestamp);
        }

        FreezeRequest getFreezeRequest() {
            return this.freezeRequest;
        }
    }
}

