/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.sql.ODynamicSQLElementFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedLifecycleListener;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import com.sonatype.nexus.hazelcast.internal.orient.AdaptiveDistributedStorage;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.entity.EntityHook;

public class SharedHazelcastPlugin
extends OHazelcastPlugin
implements OServerLifecycleListener {
    @Inject
    private static DatabaseManager databaseManager;
    private final long deployTimeout = OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    private static final ODistributedLifecycleListener STOP_NODES_JOINING;

    static {
        STOP_NODES_JOINING = new ODistributedLifecycleListener(){

            public boolean onNodeJoining(String node) {
                return false;
            }

            public void onNodeJoined(String node) {
            }

            public void onDatabaseChangeStatus(String node, String database, ODistributedServerManager.DB_STATUS status) {
            }

            public void onNodeLeft(String node) {
            }
        };
    }

    protected HazelcastInstance configureHazelcast() {
        final HazelcastInstance instance = Hazelcast.getHazelcastInstanceByName((String)"nexus");
        this.setHazelcastConfig(instance.getConfig());
        return (HazelcastInstance)Proxy.newProxyInstance(HazelcastInstance.class.getClassLoader(), new Class[]{HazelcastInstance.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("shutdown".equals(method.getName())) {
                    return null;
                }
                return method.invoke((Object)instance, args);
            }
        });
    }

    public ODistributedStorage getStorage(String dbName) {
        return this.storages.computeIfAbsent(dbName, k -> new AdaptiveDistributedStorage(this.serverInstance, (String)k));
    }

    public Object executeOnLocalNode(ODistributedRequestId req, ORemoteTask task, ODatabaseDocumentInternal db) {
        if (this.getLocalNodeId() == req.getNodeId()) {
            return super.executeOnLocalNode(req, task, db);
        }
        return EntityHook.asRemote((String)this.getNodeNameById(req.getNodeId()), () -> super.executeOnLocalNode(req, task, db));
    }

    public synchronized boolean installDatabase(boolean isStartup, String dbName, boolean forceDeployment, boolean tryWithDeltaFirst) {
        return (Boolean)EntityHook.asRemote((String)"CLUSTER-SYNC", () -> super.installDatabase(isStartup, dbName, forceDeployment, tryWithDeltaFirst));
    }

    protected void installDatabaseFromNetwork(String dbPath, String dbName, ODistributedDatabaseImpl database, String node, ODistributedDatabaseChunk firstChunk, boolean isDelta, File backupDir, OModifiableDistributedConfiguration distributedConfig) {
        if (!isDelta) {
            Orient.instance().unregisterStorageByName(dbName);
        }
        super.installDatabaseFromNetwork(dbPath, dbName, database, node, firstChunk, isDelta, backupDir, distributedConfig);
        if (!isDelta) {
            databaseManager.replaceStorage((OStorage)this.getStorage(dbName));
        }
    }

    public <T> T executeInDistributedDatabaseLock(String dbName, long originalTimeout, OModifiableDistributedConfiguration distributedConfig, OCallable<T, OModifiableDistributedConfiguration> callback) {
        long timeout = originalTimeout;
        if (timeout > 0L && timeout < this.deployTimeout && this.getNodeStatus() == ODistributedServerManager.NODE_STATUS.STARTING) {
            timeout = this.deployTimeout;
        }
        return (T)super.executeInDistributedDatabaseLock(dbName, timeout, distributedConfig, callback);
    }

    public void startup() {
        super.startup();
        if (this.enabled) {
            this.installDistributedCommands();
            this.getServerInstance().registerLifecycleListener((OServerLifecycleListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetWriteQuorum() {
        ODistributedLifecycleListener oDistributedLifecycleListener = STOP_NODES_JOINING;
        synchronized (oDistributedLifecycleListener) {
            this.registerLifecycleListener(STOP_NODES_JOINING);
            try {
                String thisNode = this.getLocalNodeName();
                this.getActiveServers().stream().filter(node -> !thisNode.equals(node)).forEach(node -> {
                    try {
                        this.removeServer((String)node, false);
                    }
                    catch (ODistributedException e) {
                        OLogManager.instance().debug((Object)this, "Ignoring distributed exception as cluster is being reset", (Throwable)e, new Object[0]);
                    }
                });
                this.getManagedDatabases().forEach(database -> this.resetWriteQuorum((String)database));
            }
            finally {
                this.unregisterLifecycleListener(STOP_NODES_JOINING);
            }
        }
    }

    private void resetWriteQuorum(String database) {
        String thisNode = this.getLocalNodeName();
        ODistributedConfiguration distributedConfig = (ODistributedConfiguration)this.executeInDistributedDatabaseLock(database, 0L, null, config -> {
            config.getAllConfiguredServers().stream().filter(node -> !thisNode.equals(node)).forEach(node -> {
                List list = config.removeServer(node);
            });
            Arrays.asList(config.getClusterNames()).forEach(cluster -> config.setServerOwner(cluster, thisNode));
            return config;
        });
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Updated distributed config for %s: %s", new Object[]{database, distributedConfig.getDocument().toJSON("prettyPrint")});
        }
    }

    public void onBeforeActivate() {
    }

    public void onAfterActivate() {
    }

    public void onBeforeDeactivate() {
        this.removeNodeFromConfiguration(this.getLocalNodeName(), false);
    }

    public void onAfterDeactivate() {
    }

    private void installDistributedCommands() {
        try {
            Field dynamicCommands = ODynamicSQLElementFactory.class.getDeclaredField("COMMANDS");
            dynamicCommands.setAccessible(true);
            Field distributedCommands = OHazelcastPlugin.class.getClassLoader().loadClass("com.orientechnologies.orient.server.distributed.sql.ODistributedCommandExecutorSQLFactory").getDeclaredField("COMMANDS");
            distributedCommands.setAccessible(true);
            ((Map)dynamicCommands.get(null)).putAll((Map)distributedCommands.get(null));
        }
        catch (Exception | LinkageError e) {
            OLogManager.instance().warn((Object)this, "Unable to register Orient HA commands", e, new Object[0]);
        }
    }
}

