/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.scheduling;

import com.google.common.base.Preconditions;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.nio.serialization.VersionedPortable;
import java.io.IOException;
import java.util.Date;
import javax.annotation.Nullable;
import org.sonatype.nexus.scheduling.TaskInfo;

public class HazelcastClusteredTaskState
implements VersionedPortable {
    public static final int CLASS_ID = 1;
    private static final String FIELD_STATE = "state";
    private static final String FIELD_RUN_STATE = "runState";
    private static final String FIELD_LAST_END_STATE = "lastEndState";
    private static final String FIELD_LAST_RUN_STARTED = "lastRunStarted";
    private static final String FIELD_LAST_RUN_DURATION = "lastRunDuration";
    private TaskInfo.State state;
    private TaskInfo.RunState runState;
    private TaskInfo.EndState lastEndState;
    private Long lastRunDuration;
    private Date lastRunStarted;

    public HazelcastClusteredTaskState() {
    }

    public HazelcastClusteredTaskState(TaskInfo taskInfo) {
        TaskInfo.CurrentState currentState = taskInfo.getCurrentState();
        this.state = (TaskInfo.State)Preconditions.checkNotNull((Object)currentState.getState());
        this.runState = currentState.getRunState();
        TaskInfo.LastRunState lastRunState = taskInfo.getLastRunState();
        if (lastRunState != null) {
            this.lastEndState = lastRunState.getEndState();
            this.lastRunStarted = lastRunState.getRunStarted();
            this.lastRunDuration = lastRunState.getRunDuration();
        }
    }

    public int getFactoryId() {
        return 1;
    }

    public int getClassId() {
        return 1;
    }

    public int getClassVersion() {
        return 1;
    }

    public TaskInfo.State getState() {
        return this.state;
    }

    @Nullable
    public TaskInfo.RunState getRunState() {
        return this.runState;
    }

    @Nullable
    public TaskInfo.EndState getLastEndState() {
        return this.lastEndState;
    }

    @Nullable
    public Date getLastRunStarted() {
        return this.lastRunStarted;
    }

    @Nullable
    public Long getLastRunDuration() {
        return this.lastRunDuration;
    }

    public void writePortable(PortableWriter writer) throws IOException {
        this.writeEnum(writer, FIELD_STATE, (Enum<?>)this.state);
        this.writeEnum(writer, FIELD_RUN_STATE, (Enum<?>)this.runState);
        this.writeEnum(writer, FIELD_LAST_END_STATE, (Enum<?>)this.lastEndState);
        writer.writeLong(FIELD_LAST_RUN_STARTED, this.lastRunStarted != null ? this.lastRunStarted.getTime() : 0L);
        writer.writeLong(FIELD_LAST_RUN_DURATION, this.lastRunDuration != null ? this.lastRunDuration : -1L);
    }

    private void writeEnum(PortableWriter writer, String field, Enum<?> e) throws IOException {
        writer.writeUTF(field, e != null ? e.name() : "");
    }

    public void readPortable(PortableReader reader) throws IOException {
        this.state = this.readEnum(reader, FIELD_STATE, TaskInfo.State.class);
        this.runState = this.readEnum(reader, FIELD_RUN_STATE, TaskInfo.RunState.class);
        this.lastEndState = this.readEnum(reader, FIELD_LAST_END_STATE, TaskInfo.EndState.class);
        long timestamp = reader.readLong(FIELD_LAST_RUN_STARTED);
        this.lastRunStarted = timestamp == 0L ? null : new Date(timestamp);
        long duration = reader.readLong(FIELD_LAST_RUN_DURATION);
        this.lastRunDuration = duration == -1L ? null : Long.valueOf(duration);
    }

    private <E extends Enum<E>> E readEnum(PortableReader reader, String field, Class<E> enumType) throws IOException {
        String name = reader.readUTF(field);
        try {
            return name.isEmpty() ? null : (E)Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Incompatible data for field " + field, e);
        }
    }
}

