/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.scheduling;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.sonatype.nexus.hazelcast.internal.HazelcastDistributorSupport;
import com.sonatype.nexus.hazelcast.internal.scheduling.HazelcastClusteredTaskState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.node.NodeAddedEvent;
import org.sonatype.nexus.common.node.NodeRemovedEvent;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.scheduling.ClusteredTaskState;
import org.sonatype.nexus.scheduling.ClusteredTaskStateStore;
import org.sonatype.nexus.scheduling.TaskInfo;

@Named(value="hazelcast")
@Singleton
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class HazelcastClusteredTaskStateStore
extends HazelcastDistributorSupport
implements ClusteredTaskStateStore,
EventAware {
    private final Provider<HazelcastInstance> hazelcastProvider;
    private final ConcurrentMap<String, IMap<String, HazelcastClusteredTaskState>> taskStatesByNodeId = new ConcurrentHashMap<String, IMap<String, HazelcastClusteredTaskState>>();

    @Inject
    public HazelcastClusteredTaskStateStore(Provider<HazelcastInstance> hazelcastProvider, NodeAccess nodeAccess) {
        super(nodeAccess);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
    }

    @Override
    protected void doStartCluster() throws Exception {
        HazelcastInstance hazelcast = (HazelcastInstance)this.hazelcastProvider.get();
        for (String nodeId : this.getNodeAccess().getMemberIds()) {
            this.taskStatesByNodeId.put(nodeId, (IMap<String, HazelcastClusteredTaskState>)hazelcast.getMap(HazelcastClusteredTaskStateStore.getMapName(nodeId)));
        }
    }

    @Override
    protected void doStopCluster() throws Exception {
    }

    private static String getMapName(String nodeId) {
        return "nexus:task-state-store:" + nodeId;
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void on(NodeAddedEvent event) {
        String nodeId = event.getNodeId();
        this.log.debug("Registering task states for node {}", (Object)nodeId);
        this.taskStatesByNodeId.put(nodeId, (IMap<String, HazelcastClusteredTaskState>)((HazelcastInstance)this.hazelcastProvider.get()).getMap(HazelcastClusteredTaskStateStore.getMapName(nodeId)));
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void on(NodeRemovedEvent event) {
        String nodeId = event.getNodeId();
        this.log.debug("Unregistering task states for node {}", (Object)nodeId);
        IMap taskStates = (IMap)this.taskStatesByNodeId.remove(nodeId);
        if (taskStates != null) {
            taskStates.destroy();
        }
    }

    @Guarded(by={"STARTED"})
    public void setLocalState(TaskInfo taskInfo) {
        Preconditions.checkNotNull((Object)taskInfo);
        if (!this.isClustered()) {
            return;
        }
        this.log.debug("Updating local task state for task {} ({}): {}-{}", new Object[]{taskInfo.getId(), taskInfo.getName(), taskInfo.getCurrentState().getState(), taskInfo.getCurrentState().getRunState()});
        String localNodeId = this.getNodeAccess().getId();
        IMap taskStates = (IMap)this.taskStatesByNodeId.get(localNodeId);
        Preconditions.checkState((taskStates != null ? 1 : 0) != 0, (Object)"no task states for local node");
        taskStates.set((Object)taskInfo.getId(), (Object)new HazelcastClusteredTaskState(taskInfo));
    }

    @Guarded(by={"STARTED"})
    public void removeClusteredState(String taskId) {
        Preconditions.checkNotNull((Object)taskId);
        if (!this.isClustered()) {
            return;
        }
        this.log.debug("Removing clustered task state for task {}", (Object)taskId);
        for (IMap taskStates : this.taskStatesByNodeId.values()) {
            taskStates.delete((Object)taskId);
        }
    }

    @Guarded(by={"STARTED"})
    public List<ClusteredTaskState> getClusteredState(String taskId) {
        Preconditions.checkNotNull((Object)taskId);
        if (!this.isClustered()) {
            return null;
        }
        ArrayList<ClusteredTaskState> clusteredTaskStates = new ArrayList<ClusteredTaskState>(this.taskStatesByNodeId.size());
        for (Map.Entry entry : this.taskStatesByNodeId.entrySet()) {
            String nodeId = (String)entry.getKey();
            HazelcastClusteredTaskState taskState = (HazelcastClusteredTaskState)((IMap)entry.getValue()).get((Object)taskId);
            if (taskState != null) {
                clusteredTaskStates.add(new ClusteredTaskState(nodeId, taskState.getState(), taskState.getRunState(), taskState.getLastEndState(), taskState.getLastRunStarted(), taskState.getLastRunDuration()));
                continue;
            }
            clusteredTaskStates.add(new ClusteredTaskState(nodeId, TaskInfo.State.WAITING, null, null, null, null));
        }
        return clusteredTaskStates;
    }
}

