/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.sequence;

import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import java.util.function.LongSupplier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.sequence.AtomicSequence;
import org.sonatype.nexus.common.sequence.AtomicSequenceFactory;
import org.sonatype.nexus.common.sequence.LocalAtomicSequenceFactory;

@Named(value="hazelcast")
@Priority(value=0x7FFFFFFF)
@Singleton
public class HazelcastAtomicSequenceFactory
implements AtomicSequenceFactory {
    private static final String DISTRIBUTED_PREFIX = "nexus:atomic-sequence";
    private final NodeAccess nodeAccess;
    private final Provider<HazelcastInstance> hazelcastProvider;
    private final LocalAtomicSequenceFactory localSequenceFactory;

    @Inject
    public HazelcastAtomicSequenceFactory(NodeAccess nodeAccess, Provider<HazelcastInstance> hazelcastProvider, LocalAtomicSequenceFactory localSequenceFactory) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
        this.localSequenceFactory = (LocalAtomicSequenceFactory)Preconditions.checkNotNull((Object)localSequenceFactory);
    }

    public AtomicSequence create(String id, LongSupplier initialValue) {
        if (this.nodeAccess.isClustered()) {
            IAtomicLong sequence = ((HazelcastInstance)this.hazelcastProvider.get()).getAtomicLong("nexus:atomic-sequence:" + id);
            if (this.nodeAccess.isOldestNode()) {
                sequence.set(initialValue.getAsLong());
            }
            return () -> sequence.incrementAndGet();
        }
        return this.localSequenceFactory.create(id, initialValue);
    }
}

