/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.nexus;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.nexus.ShiroJCacheManagerAdapter;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.security.UserIdMdcHelper;
import org.sonatype.nexus.security.authc.AuthenticationEvent;

public class NexusWebSecurityManager
extends DefaultWebSecurityManager {
    private final Provider<EventManager> eventManager;

    @Inject
    public NexusWebSecurityManager(Provider<EventManager> eventManager, Provider<CacheHelper> cacheHelper, @Named(value="${nexus.shiro.cache.defaultTimeToLive:-2m}") Provider<Time> defaultTimeToLive) {
        this.eventManager = (Provider)Preconditions.checkNotNull(eventManager);
        this.setCacheManager(new ShiroJCacheManagerAdapter(cacheHelper, defaultTimeToLive));
        this.setRememberMeManager(null);
    }

    private void post(AuthenticationToken token, boolean successful) {
        ((EventManager)this.eventManager.get()).post((Object)new AuthenticationEvent(token.getPrincipal().toString(), successful));
    }

    public Subject login(Subject subject, AuthenticationToken token) {
        try {
            subject = super.login(subject, token);
            UserIdMdcHelper.set(subject);
            this.post(token, true);
            return subject;
        }
        catch (AuthenticationException e) {
            this.post(token, false);
            throw e;
        }
    }

    public void logout(Subject subject) {
        super.logout(subject);
        UserIdMdcHelper.unset();
    }
}

