/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.nexus;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.session.mgt.SessionValidationScheduler;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusWebSessionManager
extends DefaultWebSessionManager {
    private static final Logger log = LoggerFactory.getLogger(NexusWebSessionManager.class);
    private static final String DEFAULT_NEXUS_SESSION_COOKIE_NAME = "NXSESSIONID";

    @Inject
    public void configureProperties(@Named(value="${shiro.globalSessionTimeout:-1800000}") long globalSessionTimeout, @Named(value="${nexus.sessionCookieName:-NXSESSIONID}") String sessionCookieName) {
        this.setGlobalSessionTimeout(globalSessionTimeout);
        log.info("Global session timeout: {} ms", (Object)this.getGlobalSessionTimeout());
        Cookie cookie = this.getSessionIdCookie();
        cookie.setName(sessionCookieName);
        log.info("Session-cookie prototype: name={}", (Object)cookie.getName());
    }

    protected synchronized void enableSessionValidation() {
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler == null) {
            super.enableSessionValidation();
        }
    }
}

