/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.security.AbstractPhraseService;

@Named(value="file")
@Singleton
public class FilePhraseService
extends AbstractPhraseService {
    private final Supplier<String> masterPhraseSupplier;

    @Inject
    public FilePhraseService(final @Named(value="${nexus.security.masterPhraseFile}") @Nullable File masterPhraseFile) {
        super(masterPhraseFile != null);
        this.masterPhraseSupplier = Suppliers.memoize((Supplier)new Supplier<String>(){

            public String get() {
                try {
                    return Files.asCharSource((File)masterPhraseFile, (Charset)Charsets.UTF_8).read().trim();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    @Override
    protected String getMasterPhrase() {
        return (String)this.masterPhraseSupplier.get();
    }
}

