/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.crypto.maven.MavenCipher;
import org.sonatype.nexus.security.PhraseService;

@Singleton
@Named
public class PasswordHelper
extends ComponentSupport {
    private static final String ENC = "CMMDwoV";
    private final MavenCipher mavenCipher;
    private final PhraseService phraseService;

    @Inject
    public PasswordHelper(MavenCipher mavenCipher, PhraseService phraseService) {
        this.mavenCipher = (MavenCipher)Preconditions.checkNotNull((Object)mavenCipher);
        this.phraseService = (PhraseService)Preconditions.checkNotNull((Object)phraseService);
    }

    @Nullable
    public String encrypt(@Nullable String password) {
        String encodedPassword = this.encrypt(password, this.phraseService.getPhrase(ENC));
        if (encodedPassword != null && !encodedPassword.equals(password)) {
            return this.phraseService.mark(encodedPassword);
        }
        return encodedPassword;
    }

    @Nullable
    public String encrypt(@Nullable String password, String encoding) {
        if (password == null) {
            return null;
        }
        if (this.mavenCipher.isPasswordCipher(password)) {
            this.log.warn("Value appears to be already encrypted", (Throwable)(this.log.isDebugEnabled() ? new IllegalArgumentException() : null));
            return password;
        }
        return this.mavenCipher.encrypt(password, encoding);
    }

    @Nullable
    public String decrypt(@Nullable String encodedPassword) {
        if (this.phraseService.usesLegacyEncoding(encodedPassword)) {
            return this.decrypt(encodedPassword, ENC);
        }
        return this.decrypt(encodedPassword, this.phraseService.getPhrase(ENC));
    }

    @Nullable
    public String decrypt(@Nullable String encodedPassword, String encoding) {
        if (encodedPassword == null) {
            return null;
        }
        if (!this.mavenCipher.isPasswordCipher(encodedPassword)) {
            this.log.warn("Value appears to be already decrypted", (Throwable)(this.log.isDebugEnabled() ? new IllegalArgumentException() : null));
            return encodedPassword;
        }
        return this.mavenCipher.decrypt(encodedPassword, encoding);
    }

    @Nullable
    public String tryDecrypt(@Nullable String encodedPassword) {
        try {
            return this.decrypt(encodedPassword);
        }
        catch (RuntimeException e) {
            this.log.warn("Failed to decrypt value, loading as plain text", (Throwable)(this.log.isDebugEnabled() ? e : null));
            return encodedPassword;
        }
    }
}

