/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.authc;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.shiro.web.filter.authc.AuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.text.Strings2;

@Named
@Singleton
public class AntiCsrfFilter
extends AuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(AntiCsrfFilter.class);
    public static final String ENABLED = "nexus.security.anticsrftoken.enabled";
    private static final String ERROR_MESSAGE_TOKEN_MISMATCH = "Anti cross-site request forgery token mismatch";
    public static final String NAME = "nx-anticsrf-authc";
    public static final String ANTI_CSRF_TOKEN_NAME = "NX-ANTI-CSRF-TOKEN";
    private static final String DEFAULT_SESSION_COOKIE_NAME = "NXSESSIONID";
    private final boolean enabled;
    private final String sessionCookieName;

    @Inject
    public AntiCsrfFilter(@Named(value="${nexus.security.anticsrftoken.enabled:-true}") boolean enabled, @Named(value="${nexus.sessionCookieName:-NXSESSIONID}") String sessionCookieName) {
        this.enabled = enabled;
        this.sessionCookieName = sessionCookieName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!this.isEnabled()) {
            return true;
        }
        return this.isSafeHttpMethod(httpRequest) || this.isNotBrowserRequest(httpRequest) || this.isMultiPartFormDataPost(httpRequest) || this.isSessionAndRefererAbsent(httpRequest) || this.isAntiCsrfTokenValid(httpRequest);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        log.debug("Rejecting request from {} due to invalid cross-site request forgery token", (Object)request.getRemoteAddr());
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setStatus(401);
        httpResponse.setContentType("text/plain");
        httpResponse.getWriter().print(ERROR_MESSAGE_TOKEN_MISMATCH);
        return false;
    }

    private boolean isNotBrowserRequest(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent == null || !userAgent.startsWith("Mozilla/");
    }

    private boolean isSafeHttpMethod(HttpServletRequest request) {
        String method = request.getMethod();
        return "GET".equals(method) || "HEAD".equals(method);
    }

    private boolean isMultiPartFormDataPost(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && !Strings2.isBlank((String)request.getContentType()) && MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(MediaType.valueOf((String)request.getContentType()));
    }

    private boolean isSessionAndRefererAbsent(HttpServletRequest request) {
        return !this.getCookie(request, this.sessionCookieName).isPresent() && this.isRefererAbsent(request);
    }

    private boolean isRefererAbsent(HttpServletRequest request) {
        return Strings2.isBlank((String)request.getHeader("Referer"));
    }

    private Optional<String> getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookieName.equals(cookie.getName())) {
                    return Optional.ofNullable(cookie.getValue());
                }
                ++n2;
            }
        }
        return Optional.empty();
    }

    private Optional<String> getAntiCsrfTokenCookie(HttpServletRequest request) {
        return this.getCookie(request, ANTI_CSRF_TOKEN_NAME);
    }

    private boolean isAntiCsrfTokenValid(HttpServletRequest request) {
        Optional<String> header = Optional.ofNullable(request.getHeader(ANTI_CSRF_TOKEN_NAME));
        Optional<String> cookie = this.getAntiCsrfTokenCookie(request);
        return header.isPresent() && cookie.isPresent() && header.equals(cookie);
    }
}

