/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.authc;

import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.realm.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstSuccessfulModularRealmAuthenticator
extends ModularRealmAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(FirstSuccessfulModularRealmAuthenticator.class);

    protected AuthenticationInfo doMultiRealmAuthentication(Collection<Realm> realms, AuthenticationToken token) {
        log.trace("Iterating through [{}] realms for PAM authentication", (Object)realms.size());
        for (Realm realm : realms) {
            if (realm.supports(token)) {
                log.trace("Attempting to authenticate token [{}] using realm of type [{}]", (Object)token, (Object)realm);
                try {
                    AuthenticationInfo info = realm.getAuthenticationInfo(token);
                    if (info != null) {
                        return info;
                    }
                    log.trace("Realm [{}] returned null when authenticating token [{}]", (Object)realm, (Object)token);
                }
                catch (Throwable t) {
                    log.trace("Realm [{}] threw an exception during a multi-realm authentication attempt", (Object)realm, (Object)t);
                }
                continue;
            }
            log.trace("Realm of type [{}] does not support token [{}]; skipping realm", (Object)realm, (Object)token);
        }
        throw new AuthenticationException("Authentication token of type [" + token.getClass() + "] could not be authenticated by any configured realms.  Please ensure that at least one realm can " + "authenticate these tokens.");
    }
}

