/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.config;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import org.sonatype.nexus.common.entity.AbstractEntity;

public class CPrivilege
extends AbstractEntity
implements Serializable,
Cloneable {
    private String id;
    private String name;
    private String description;
    private String type;
    private Map<String, String> properties;
    private boolean readOnly = false;
    private String version;

    public void setProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        return this.properties;
    }

    public String getProperty(String key) {
        return this.getProperties().get(key);
    }

    public String getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void removeProperty(String key) {
        this.getProperties().remove(key);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public CPrivilege clone() {
        try {
            CPrivilege copy = (CPrivilege)super.clone();
            if (this.properties != null) {
                copy.properties = Maps.newHashMap(this.properties);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type='" + this.type + '\'' + ", properties=" + this.properties + ", readOnly=" + this.readOnly + ", version='" + this.version + '\'' + '}';
    }
}

