/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.config;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import org.sonatype.nexus.common.entity.AbstractEntity;

public class CUserRoleMapping
extends AbstractEntity
implements Serializable,
Cloneable {
    private static final Set<String> CASE_INSENSITIVE_SOURCES = Sets.newHashSet((Object[])new String[]{"default".toLowerCase(), "crowd", "ldap"});
    private String userId;
    private String source;
    private Set<String> roles;
    private String version;

    public void addRole(String string) {
        this.getRoles().add(string);
    }

    public Set<String> getRoles() {
        if (this.roles == null) {
            this.roles = Sets.newHashSet();
        }
        return this.roles;
    }

    public String getSource() {
        return this.source;
    }

    public String getUserId() {
        return this.userId;
    }

    public void removeRole(String string) {
        this.getRoles().remove(string);
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public CUserRoleMapping clone() {
        try {
            CUserRoleMapping copy = (CUserRoleMapping)super.clone();
            if (this.roles != null) {
                copy.roles = Sets.newHashSet(this.roles);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "userId='" + this.userId + '\'' + ", source='" + this.source + '\'' + ", roles=" + this.roles + ", version='" + this.version + '\'' + '}';
    }

    public static boolean isCaseInsensitiveSource(String source) {
        return CASE_INSENSITIVE_SOURCES.contains(source.toLowerCase());
    }
}

