/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.security.authz.AuthorizationConfigurationChanged;
import org.sonatype.nexus.security.authz.AuthorizationManager;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CRole;
import org.sonatype.nexus.security.config.SecurityConfigurationManager;
import org.sonatype.nexus.security.privilege.NoSuchPrivilegeException;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.privilege.PrivilegeCreatedEvent;
import org.sonatype.nexus.security.privilege.PrivilegeDeletedEvent;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptor;
import org.sonatype.nexus.security.privilege.PrivilegeUpdatedEvent;
import org.sonatype.nexus.security.role.NoSuchRoleException;
import org.sonatype.nexus.security.role.Role;
import org.sonatype.nexus.security.role.RoleCreatedEvent;
import org.sonatype.nexus.security.role.RoleDeletedEvent;
import org.sonatype.nexus.security.role.RoleUpdatedEvent;

@Named(value="default")
@Singleton
public class AuthorizationManagerImpl
implements AuthorizationManager {
    public static final String SOURCE = "default";
    private final SecurityConfigurationManager configuration;
    private final EventManager eventManager;
    private final List<PrivilegeDescriptor> privilegeDescriptors;

    @Inject
    public AuthorizationManagerImpl(SecurityConfigurationManager configuration, EventManager eventManager, List<PrivilegeDescriptor> privilegeDescriptors) {
        this.configuration = configuration;
        this.eventManager = eventManager;
        this.privilegeDescriptors = (List)Preconditions.checkNotNull(privilegeDescriptors);
    }

    @Override
    public String getSource() {
        return SOURCE;
    }

    private Role convert(CRole source) {
        Role target = new Role();
        target.setRoleId(source.getId());
        target.setVersion(source.getVersion());
        target.setName(source.getName());
        target.setSource(SOURCE);
        target.setDescription(source.getDescription());
        target.setReadOnly(source.isReadOnly());
        target.setPrivileges(Sets.newHashSet(source.getPrivileges()));
        target.setRoles(Sets.newHashSet(source.getRoles()));
        return target;
    }

    private CRole convert(Role source) {
        CRole target = new CRole();
        target.setId(source.getRoleId());
        target.setVersion(source.getVersion());
        target.setName(source.getName());
        target.setDescription(source.getDescription());
        target.setReadOnly(source.isReadOnly());
        if (source.getPrivileges() != null) {
            target.setPrivileges(Sets.newHashSet(source.getPrivileges()));
        } else {
            target.setPrivileges(Sets.newHashSet());
        }
        if (source.getRoles() != null) {
            target.setRoles(Sets.newHashSet(source.getRoles()));
        } else {
            target.setRoles(Sets.newHashSet());
        }
        return target;
    }

    private CPrivilege convert(Privilege source) {
        CPrivilege target = new CPrivilege();
        target.setId(source.getId());
        target.setVersion(source.getVersion());
        target.setName(source.getName());
        target.setDescription(source.getDescription());
        target.setReadOnly(source.isReadOnly());
        target.setType(source.getType());
        if (source.getProperties() != null) {
            target.setProperties(Maps.newHashMap(source.getProperties()));
        }
        return target;
    }

    private Privilege convert(CPrivilege source) {
        Privilege target = new Privilege();
        target.setId(source.getId());
        target.setVersion(source.getVersion());
        target.setName(source.getName() == null ? source.getId() : source.getName());
        target.setDescription(source.getDescription());
        target.setReadOnly(source.isReadOnly());
        target.setType(source.getType());
        target.setProperties(Maps.newHashMap(source.getProperties()));
        PrivilegeDescriptor descriptor = this.descriptor(source.getType());
        if (descriptor != null) {
            target.setPermission(descriptor.createPermission(source));
        }
        return target;
    }

    @Nullable
    private PrivilegeDescriptor descriptor(String type) {
        for (PrivilegeDescriptor descriptor : this.privilegeDescriptors) {
            if (!type.equals(descriptor.getType())) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public Set<Role> listRoles() {
        HashSet<Role> roles = new HashSet<Role>();
        List<CRole> secRoles = this.configuration.listRoles();
        for (CRole CRole2 : secRoles) {
            roles.add(this.convert(CRole2));
        }
        return roles;
    }

    @Override
    public Role getRole(String roleId) throws NoSuchRoleException {
        return this.convert(this.configuration.readRole(roleId));
    }

    @Override
    public Role addRole(Role role) {
        CRole secRole = this.convert(role);
        this.configuration.createRole(secRole);
        this.eventManager.post((Object)new RoleCreatedEvent(role));
        this.fireAuthorizationChangedEvent();
        return this.convert(secRole);
    }

    @Override
    public Role updateRole(Role role) throws NoSuchRoleException {
        CRole secRole = this.convert(role);
        this.configuration.updateRole(secRole);
        this.eventManager.post((Object)new RoleUpdatedEvent(role));
        this.fireAuthorizationChangedEvent();
        return this.convert(secRole);
    }

    @Override
    public void deleteRole(String roleId) throws NoSuchRoleException {
        Role role = this.getRole(roleId);
        this.configuration.deleteRole(roleId);
        this.eventManager.post((Object)new RoleDeletedEvent(role));
        this.fireAuthorizationChangedEvent();
    }

    @Override
    public Set<Privilege> listPrivileges() {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        List<CPrivilege> secPrivs = this.configuration.listPrivileges();
        for (CPrivilege CPrivilege2 : secPrivs) {
            privileges.add(this.convert(CPrivilege2));
        }
        return privileges;
    }

    @Override
    public Privilege getPrivilege(String privilegeId) throws NoSuchPrivilegeException {
        return this.convert(this.configuration.readPrivilege(privilegeId));
    }

    @Override
    public Privilege addPrivilege(Privilege privilege) {
        CPrivilege secPriv = this.convert(privilege);
        this.configuration.createPrivilege(secPriv);
        this.eventManager.post((Object)new PrivilegeCreatedEvent(privilege));
        this.fireAuthorizationChangedEvent();
        return this.convert(secPriv);
    }

    @Override
    public Privilege updatePrivilege(Privilege privilege) throws NoSuchPrivilegeException {
        CPrivilege secPriv = this.convert(privilege);
        this.configuration.updatePrivilege(secPriv);
        this.eventManager.post((Object)new PrivilegeUpdatedEvent(privilege));
        this.fireAuthorizationChangedEvent();
        return this.convert(secPriv);
    }

    @Override
    public void deletePrivilege(String privilegeId) throws NoSuchPrivilegeException {
        Privilege privilege = this.getPrivilege(privilegeId);
        this.configuration.deletePrivilege(privilegeId);
        this.eventManager.post((Object)new PrivilegeDeletedEvent(privilege));
        this.fireAuthorizationChangedEvent();
    }

    @Override
    public boolean supportsWrite() {
        return true;
    }

    private void fireAuthorizationChangedEvent() {
        this.eventManager.post((Object)new AuthorizationConfigurationChanged());
    }
}

