/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.privilege;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptor;

public abstract class PrivilegeDescriptorSupport
implements PrivilegeDescriptor {
    public static final String ALL = "*";
    private final String type;

    public PrivilegeDescriptorSupport(String type) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "type='" + this.type + '\'' + '}';
    }

    protected String readProperty(CPrivilege privilege, String name, String defaultValue) {
        String value = privilege.getProperty(name);
        if (Strings.nullToEmpty((String)value).isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    protected String readProperty(CPrivilege privilege, String name) {
        String value = privilege.getProperty(name);
        Preconditions.checkState((!Strings.nullToEmpty((String)value).isEmpty() ? 1 : 0) != 0, (String)"Missing required property: %s", (Object)name);
        return value;
    }

    protected List<String> readListProperty(CPrivilege privilege, String name, String defaultValue) {
        String value = this.readProperty(privilege, name, defaultValue);
        return Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value));
    }

    protected static String humanizeName(String name, String format) {
        if (ALL.equals(name)) {
            if (ALL.equals(format)) {
                return "all";
            }
            return "all '" + format + "'-format";
        }
        return name;
    }

    protected static String humanizeActions(String ... actions) {
        Preconditions.checkArgument((actions.length > 0 ? 1 : 0) != 0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Joiner.on((String)", ").join(Iterables.transform(Arrays.asList(actions), (Function)new Function<String, String>(){

            public String apply(String action) {
                if (PrivilegeDescriptorSupport.ALL.equals(action)) {
                    return "All";
                }
                return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, action);
            }
        })));
        if (actions.length > 1 || ALL.equals(actions[0])) {
            stringBuilder.append(" privileges");
        } else {
            stringBuilder.append(" privilege");
        }
        return stringBuilder.toString();
    }
}

