/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.privilege;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.security.authz.WildcardPermission2;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CPrivilegeBuilder;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptorSupport;

@Named(value="wildcard")
@Singleton
public class WildcardPrivilegeDescriptor
extends PrivilegeDescriptorSupport {
    public static final String TYPE = "wildcard";
    public static final String P_PATTERN = "pattern";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = ImmutableList.of((Object)new StringTextFormField("pattern", messages.pattern(), messages.patternHelp(), true));

    public WildcardPrivilegeDescriptor() {
        super(TYPE);
    }

    @Override
    public Permission createPermission(CPrivilege privilege) {
        assert (privilege != null);
        String pattern = this.readProperty(privilege, P_PATTERN);
        return new WildcardPermission2(pattern);
    }

    @Override
    public List<FormField> getFormFields() {
        return this.formFields;
    }

    @Override
    public String getName() {
        return messages.name();
    }

    public static String id(String pattern) {
        return pattern;
    }

    public static CPrivilege privilege(String pattern) {
        return new CPrivilegeBuilder().type(TYPE).id(WildcardPrivilegeDescriptor.id(pattern)).property(P_PATTERN, pattern).create();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Wildcard")
        public String name();

        @MessageBundle.DefaultMessage(value="Pattern")
        public String pattern();

        @MessageBundle.DefaultMessage(value="The regex pattern")
        public String patternHelp();
    }
}

