/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.token;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;

public abstract class BearerTokenManager
extends ComponentSupport {
    protected final ApiKeyStore apiKeyStore;
    protected final SecurityHelper securityHelper;
    private final String format;

    @Inject
    public BearerTokenManager(ApiKeyStore apiKeyStore, SecurityHelper securityHelper, String format) {
        this.apiKeyStore = (ApiKeyStore)Preconditions.checkNotNull((Object)apiKeyStore);
        this.securityHelper = (SecurityHelper)((Object)Preconditions.checkNotNull((Object)((Object)securityHelper)));
        this.format = (String)Preconditions.checkNotNull((Object)format);
    }

    protected String createToken(PrincipalCollection principals) {
        Preconditions.checkNotNull((Object)principals);
        char[] apiKey = this.apiKeyStore.getApiKey(this.format, principals);
        if (apiKey != null) {
            return String.valueOf(this.format) + "." + new String(apiKey);
        }
        return String.valueOf(this.format) + "." + new String(this.apiKeyStore.createApiKey(this.format, principals));
    }

    public boolean deleteToken() {
        PrincipalCollection principals = this.securityHelper.subject().getPrincipals();
        if (this.apiKeyStore.getApiKey(this.format, principals) != null) {
            this.apiKeyStore.deleteApiKey(this.format, this.securityHelper.subject().getPrincipals());
            return true;
        }
        return false;
    }
}

