/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.token;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.authc.NexusApiKeyAuthenticationToken;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.security.user.UserStatus;

public abstract class BearerTokenRealm
extends AuthenticatingRealm {
    @VisibleForTesting
    static final String ANONYMOUS_USER = "anonymous";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ApiKeyStore keyStore;
    private final UserPrincipalsHelper principalsHelper;
    private final String format;

    public BearerTokenRealm(ApiKeyStore keyStore, UserPrincipalsHelper principalsHelper, String format) {
        this.keyStore = (ApiKeyStore)Preconditions.checkNotNull((Object)keyStore);
        this.principalsHelper = (UserPrincipalsHelper)((Object)Preconditions.checkNotNull((Object)((Object)principalsHelper)));
        this.format = (String)Preconditions.checkNotNull((Object)format);
        this.setName(format);
        this.setAuthenticationCachingEnabled(false);
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof NexusApiKeyAuthenticationToken && this.format.equals(token.getPrincipal());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
        Preconditions.checkNotNull((Object)token);
        PrincipalCollection principals = this.keyStore.getPrincipals(this.format, (char[])token.getCredentials());
        if (principals != null) {
            try {
                if (this.anonymousAndSupported(principals) || UserStatus.active.equals((Object)this.principalsHelper.getUserStatus(principals))) {
                    ((NexusApiKeyAuthenticationToken)token).setPrincipal(principals.getPrimaryPrincipal());
                    return new SimpleAuthenticationInfo(principals, token.getCredentials());
                }
            }
            catch (UserNotFoundException e) {
                this.log.debug("Realm did not find user", (Throwable)e);
                this.keyStore.deleteApiKeys(principals);
            }
        }
        return null;
    }

    @Nullable
    protected Object getAuthenticationCacheKey(@Nullable AuthenticationToken token) {
        PrincipalCollection principals;
        if (token != null && (principals = this.keyStore.getPrincipals(this.format, (char[])token.getCredentials())) != null) {
            return principals.getPrimaryPrincipal();
        }
        return null;
    }

    protected boolean isAnonymousSupported() {
        return false;
    }

    private boolean anonymousAndSupported(PrincipalCollection principals) {
        return ANONYMOUS_USER.equals(principals.getPrimaryPrincipal()) && this.isAnonymousSupported();
    }
}

