/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.user;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.user.UserExists;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

@Named
public class UserExistsValidator
extends ConstraintValidatorSupport<UserExists, String> {
    private final SecuritySystem securitySystem;

    @Inject
    public UserExistsValidator(SecuritySystem securitySystem) {
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        this.log.trace("Validating user exists: {}", (Object)value);
        try {
            this.securitySystem.getUser(value);
            return true;
        }
        catch (UserNotFoundException userNotFoundException) {
            return false;
        }
    }
}

