/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.google.common.base.Strings;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;

@Named
public class AmazonS3Factory
extends ComponentSupport {
    public static final String DEFAULT = "DEFAULT";

    public AmazonS3 create(BlobStoreConfiguration blobStoreConfiguration) {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        String accessKeyId = (String)blobStoreConfiguration.attributes("s3").get("accessKeyId", String.class);
        String secretAccessKey = (String)blobStoreConfiguration.attributes("s3").get("secretAccessKey", String.class);
        String region = (String)blobStoreConfiguration.attributes("s3").get("region", String.class);
        String signerType = (String)blobStoreConfiguration.attributes("s3").get("signertype", String.class);
        String forcePathStyle = (String)blobStoreConfiguration.attributes("s3").get("forcepathstyle", String.class);
        if (!Strings.isNullOrEmpty((String)accessKeyId) && !Strings.isNullOrEmpty((String)secretAccessKey)) {
            String sessionToken = (String)blobStoreConfiguration.attributes("s3").get("sessionToken", String.class);
            AWSCredentials credentials = this.buildCredentials(accessKeyId, secretAccessKey, sessionToken);
            String assumeRole = (String)blobStoreConfiguration.attributes("s3").get("assumeRole", String.class);
            AWSCredentialsProvider credentialsProvider = this.buildCredentialsProvider(credentials, region, assumeRole);
            builder = (AmazonS3ClientBuilder)builder.withCredentials(credentialsProvider);
        }
        if (!this.isNullOrEmptyOrDefault(region)) {
            String endpoint = (String)blobStoreConfiguration.attributes("s3").get("endpoint", String.class);
            builder = !Strings.isNullOrEmpty((String)endpoint) ? (AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, region)) : (AmazonS3ClientBuilder)builder.withRegion(region);
        }
        if (!this.isNullOrEmptyOrDefault(signerType)) {
            ClientConfiguration clientConfiguration = PredefinedClientConfigurations.defaultConfig();
            clientConfiguration.setSignerOverride(signerType);
            builder = (AmazonS3ClientBuilder)builder.withClientConfiguration(clientConfiguration);
        }
        builder = (AmazonS3ClientBuilder)builder.withPathStyleAccessEnabled(Boolean.valueOf(Boolean.parseBoolean(forcePathStyle)));
        return (AmazonS3)builder.build();
    }

    private AWSCredentials buildCredentials(String accessKeyId, String secretAccessKey, String sessionToken) {
        if (Strings.isNullOrEmpty((String)sessionToken)) {
            return new BasicAWSCredentials(accessKeyId, secretAccessKey);
        }
        return new BasicSessionCredentials(accessKeyId, secretAccessKey, sessionToken);
    }

    private AWSCredentialsProvider buildCredentialsProvider(AWSCredentials credentials, String region, String assumeRole) {
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider(credentials);
        if (Strings.isNullOrEmpty((String)assumeRole)) {
            return credentialsProvider;
        }
        String stsRegion = Strings.isNullOrEmpty((String)region) ? this.defaultRegion() : region;
        AWSSecurityTokenService securityTokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(stsRegion)).withCredentials((AWSCredentialsProvider)credentialsProvider)).build();
        return new STSAssumeRoleSessionCredentialsProvider.Builder(assumeRole, "nexus-s3-session").withStsClient(securityTokenService).build();
    }

    private String defaultRegion() {
        try {
            return new DefaultAwsRegionProviderChain().getRegion();
        }
        catch (SdkClientException e) {
            String region = Regions.DEFAULT_REGION.getName();
            this.log.warn("Default AWS region not configured, using {}", (Object)region, (Object)e);
            return region;
        }
    }

    private boolean isNullOrEmptyOrDefault(String value) {
        return Strings.isNullOrEmpty((String)value) || DEFAULT.equals(value);
    }
}

