/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.sonatype.nexus.blobstore.BlobAttributesSupport;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.blobstore.s3.internal.S3PropertiesFile;

public class S3BlobAttributes
extends BlobAttributesSupport<S3PropertiesFile> {
    public S3BlobAttributes(AmazonS3 s3, String bucket, String key) {
        super((Properties)((Object)new S3PropertiesFile(s3, bucket, key)), null, null);
    }

    public S3BlobAttributes(AmazonS3 s3, String bucket, String key, Map<String, String> headers, BlobMetrics metrics) {
        super((Properties)((Object)new S3PropertiesFile(s3, bucket, key)), (Map)Preconditions.checkNotNull(headers), (BlobMetrics)Preconditions.checkNotNull((Object)metrics));
    }

    public boolean load() throws IOException {
        if (!((S3PropertiesFile)((Object)this.propertiesFile)).exists()) {
            return false;
        }
        ((S3PropertiesFile)((Object)this.propertiesFile)).load();
        this.readFrom(this.propertiesFile);
        return true;
    }

    public void store() throws IOException {
        this.writeTo(this.propertiesFile);
        ((S3PropertiesFile)((Object)this.propertiesFile)).store();
    }
}

