/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ValidationException;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.BlobStoreDescriptorSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.PasswordFormField;
import org.sonatype.nexus.formfields.StringTextFormField;

@Named(value="S3")
public class S3BlobStoreDescriptor
extends BlobStoreDescriptorSupport {
    public static final String TYPE = "S3";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final BlobStoreManager blobStoreManager;
    private final FormField bucket;
    private final FormField prefix;
    private final FormField accessKeyId;
    private final FormField secretAccessKey;
    private final FormField sessionToken;
    private final FormField assumeRole;
    private final FormField region;
    private final FormField endpoint;
    private final FormField expiration;
    private final FormField signerType;
    private final FormField forcePathStyle;

    @Inject
    public S3BlobStoreDescriptor(BlobStoreQuotaService quotaService, BlobStoreManager blobStoreManager) {
        super(quotaService);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.bucket = new StringTextFormField("bucket", messages.bucketLabel(), messages.bucketHelp(), true, "^([a-z]|(\\d(?!\\d{0,2}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})))([a-z\\d]|(\\.(?!(\\.|-)))|(-(?!\\.))){1,61}[a-z\\d]$");
        this.prefix = new StringTextFormField("prefix", messages.prefixLabel(), messages.prefixHelp(), false);
        this.accessKeyId = new StringTextFormField("accessKeyId", messages.accessKeyIdLabel(), messages.accessKeyIdHelp(), false);
        this.secretAccessKey = new PasswordFormField("secretAccessKey", messages.secretAccessKeyLabel(), messages.secretAccessKeyHelp(), false);
        this.assumeRole = new StringTextFormField("assumeRole", messages.assumeRoleLabel(), messages.assumeRoleHelp(), false);
        this.sessionToken = new StringTextFormField("sessionToken", messages.sessionTokenLabel(), messages.sessionTokenHelp(), false);
        this.region = new ComboboxFormField("region", messages.regionLabel(), messages.regionHelp(), true, (Object)"DEFAULT").withStoreApi("s3_S3.regions");
        this.region.getAttributes().put("sortProperty", "order");
        this.endpoint = new StringTextFormField("endpoint", messages.endpointLabel(), messages.endpointHelp(), false);
        this.expiration = new NumberTextFormField("expiration", messages.expirationLabel(), messages.expirationHelp(), false).withInitialValue((Number)3).withMinimumValue((Number)-1);
        this.signerType = new ComboboxFormField("signertype", messages.signerTypeLabel(), messages.signerTypeHelp(), true, (Object)"DEFAULT").withStoreApi("s3_S3.signertypes");
        this.signerType.getAttributes().put("sortProperty", "order");
        this.forcePathStyle = new CheckboxFormField("forcepathstyle", messages.forcePathStyleLabel(), messages.forcePathStyleHelp(), true).withInitialValue(Boolean.valueOf(false));
    }

    public String getName() {
        return messages.name();
    }

    public List<FormField> getFormFields() {
        return Arrays.asList(this.bucket, this.prefix, this.accessKeyId, this.secretAccessKey, this.sessionToken, this.assumeRole, this.region, this.endpoint, this.expiration, this.signerType, this.forcePathStyle);
    }

    public void validateConfig(BlobStoreConfiguration config) {
        super.validateConfig(config);
        for (BlobStore existingBlobStore : this.blobStoreManager.browse()) {
            this.validateOverlappingBucketWithConfiguration(config, existingBlobStore.getBlobStoreConfiguration());
        }
    }

    private void validateOverlappingBucketWithConfiguration(BlobStoreConfiguration newConfig, BlobStoreConfiguration existingConfig) {
        String newName = newConfig.getName();
        String newBucket = (String)newConfig.attributes("s3").get("bucket", String.class, (Object)"");
        String newPrefix = (String)newConfig.attributes("s3").get("prefix", String.class, (Object)"");
        String newEndpoint = (String)newConfig.attributes("s3").get("endpoint", String.class, (Object)"");
        if (!existingConfig.getName().equals(newName) && existingConfig.getType().equals(TYPE)) {
            String existingBucket = (String)existingConfig.attributes("s3").get("bucket", String.class, (Object)"");
            String existingPrefix = (String)existingConfig.attributes("s3").get("prefix", String.class, (Object)"");
            String existingEndpoint = (String)existingConfig.attributes("s3").get("endpoint", String.class, (Object)"");
            if (newBucket.equals(existingBucket) && newEndpoint.equals(existingEndpoint) && this.prefixesOverlap(existingPrefix, newPrefix)) {
                String message = String.format("Blob Store '%s' is already using bucket '%s'", existingConfig.getName(), existingBucket);
                if (!newPrefix.isEmpty() || !existingPrefix.isEmpty()) {
                    message = String.valueOf(message) + String.format(" with prefix '%s'", existingPrefix);
                }
                if (!newEndpoint.isEmpty() || !existingEndpoint.isEmpty()) {
                    message = String.valueOf(message) + String.format(" on endpoint '%s'", existingEndpoint);
                }
                throw new ValidationException(message);
            }
        }
    }

    private boolean prefixesOverlap(String prefix1, String prefix2) {
        String prefix2WithDelimiters;
        String prefix1WithDelimiters = ("/" + prefix1 + "/").replaceAll("//", "/");
        return prefix1WithDelimiters.startsWith(prefix2WithDelimiters = ("/" + prefix2 + "/").replaceAll("//", "/")) || prefix2WithDelimiters.startsWith(prefix1WithDelimiters);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="S3")
        public String name();

        @MessageBundle.DefaultMessage(value="Bucket")
        public String bucketLabel();

        @MessageBundle.DefaultMessage(value="S3 Bucket Name (must be between 3 and 63 characters long containing only lower-case characters, numbers, periods, and dashes)")
        public String bucketHelp();

        @MessageBundle.DefaultMessage(value="Prefix")
        public String prefixLabel();

        @MessageBundle.DefaultMessage(value="S3 Path prefix")
        public String prefixHelp();

        @MessageBundle.DefaultMessage(value="Access Key ID (Optional)")
        public String accessKeyIdLabel();

        @MessageBundle.DefaultMessage(value="The AWS Access Key ID used for authentication when IAM roles are not being used")
        public String accessKeyIdHelp();

        @MessageBundle.DefaultMessage(value="Secret Access Key (Optional)")
        public String secretAccessKeyLabel();

        @MessageBundle.DefaultMessage(value="The AWS Secret Access Key used for authentication when IAM roles are not being used")
        public String secretAccessKeyHelp();

        @MessageBundle.DefaultMessage(value="Session Token (Optional)")
        public String sessionTokenLabel();

        @MessageBundle.DefaultMessage(value="An STS Session Token, if required")
        public String sessionTokenHelp();

        @MessageBundle.DefaultMessage(value="Assume Role ARN (Optional)")
        public String assumeRoleLabel();

        @MessageBundle.DefaultMessage(value="Optional ARN for Role to Assume, if required")
        public String assumeRoleHelp();

        @MessageBundle.DefaultMessage(value="Region")
        public String regionLabel();

        @MessageBundle.DefaultMessage(value="The AWS Region to use")
        public String regionHelp();

        @MessageBundle.DefaultMessage(value="Endpoint URL (Optional)")
        public String endpointLabel();

        @MessageBundle.DefaultMessage(value="A custom endpoint URL for third party object stores using the S3 API")
        public String endpointHelp();

        @MessageBundle.DefaultMessage(value="Expiration Days")
        public String expirationLabel();

        @MessageBundle.DefaultMessage(value="How many days until deleted blobs are finally removed from the S3 bucket (-1 to disable)")
        public String expirationHelp();

        @MessageBundle.DefaultMessage(value="Signature Version")
        public String signerTypeLabel();

        @MessageBundle.DefaultMessage(value="An API signature version which may be required for third party object stores using the S3 API")
        public String signerTypeHelp();

        @MessageBundle.DefaultMessage(value="Configures the client to use path-style access")
        public String forcePathStyleLabel();

        @MessageBundle.DefaultMessage(value="Setting this flag will result in path-style access being used for all requests")
        public String forcePathStyleHelp();
    }
}

