/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.BlobStoreMetricsStoreSupport;
import org.sonatype.nexus.blobstore.PeriodicJobService;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.blobstore.s3.internal.S3PropertiesFile;
import org.sonatype.nexus.common.node.NodeAccess;

@Named
public class S3BlobStoreMetricsStore
extends BlobStoreMetricsStoreSupport<S3PropertiesFile> {
    static final ImmutableMap<String, Long> AVAILABLE_SPACE_BY_FILE_STORE = ImmutableMap.of((Object)"s3", (Object)Long.MAX_VALUE);
    private String bucket;
    private String bucketPrefix;
    private AmazonS3 s3;

    @Inject
    public S3BlobStoreMetricsStore(PeriodicJobService jobService, NodeAccess nodeAccess, BlobStoreQuotaService quotaService, @Named(value="${nexus.blobstore.quota.warnIntervalSeconds:-60}") int quotaCheckInterval) {
        super(nodeAccess, jobService, quotaService, quotaCheckInterval);
    }

    protected S3PropertiesFile getProperties() {
        return new S3PropertiesFile(this.s3, this.bucket, String.valueOf(this.bucketPrefix) + this.nodeAccess.getId() + "-" + "metrics.properties");
    }

    protected AccumulatingBlobStoreMetrics getAccumulatingBlobStoreMetrics() {
        return new AccumulatingBlobStoreMetrics(0L, 0L, AVAILABLE_SPACE_BY_FILE_STORE, true);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.bucket = null;
        this.s3 = null;
        this.bucketPrefix = null;
    }

    protected Stream<S3PropertiesFile> backingFiles() {
        if (this.s3 == null) {
            return Stream.empty();
        }
        Stream<S3PropertiesFile> stream = this.s3.listObjects(this.bucket, String.valueOf(this.bucketPrefix) + this.nodeAccess.getId()).getObjectSummaries().stream().filter(Objects::nonNull).filter(summary -> summary.getKey().endsWith("metrics.properties")).map(summary -> new S3PropertiesFile(this.s3, this.bucket, summary.getKey()));
        return stream;
    }

    public void setBucket(String bucket) {
        Preconditions.checkState((this.bucket == null ? 1 : 0) != 0, (Object)"Do not initialize twice");
        Preconditions.checkNotNull((Object)bucket);
        this.bucket = bucket;
    }

    public void setS3(AmazonS3 s3) {
        Preconditions.checkState((this.s3 == null ? 1 : 0) != 0, (Object)"Do not initialize twice");
        Preconditions.checkNotNull((Object)s3);
        this.s3 = s3;
    }

    public void setBucketPrefix(String bucketPrefix) {
        Preconditions.checkState((this.bucketPrefix == null ? 1 : 0) != 0, (Object)"Do not initialize twice");
        Preconditions.checkNotNull((Object)bucketPrefix);
        this.bucketPrefix = bucketPrefix;
    }

    public void remove() {
        this.backingFiles().forEach(metricsFile -> {
            try {
                metricsFile.remove();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

