/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.s3.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.property.ImplicitSourcePropertiesFile;

public class S3PropertiesFile
extends ImplicitSourcePropertiesFile {
    private static final Logger log = LoggerFactory.getLogger(S3PropertiesFile.class);
    private final AmazonS3 s3;
    private final String bucket;
    private final String key;

    public S3PropertiesFile(AmazonS3 s3, String bucket, String key) {
        this.s3 = (AmazonS3)Preconditions.checkNotNull((Object)s3);
        this.bucket = (String)Preconditions.checkNotNull((Object)bucket);
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    public void load() throws IOException {
        log.debug("Loading: {}/{}", (Object)this.bucket, (Object)this.key);
        Throwable throwable = null;
        Object var2_3 = null;
        try (S3Object object = this.s3.getObject(this.bucket, this.key);){
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (S3ObjectInputStream inputStream = object.getObjectContent();){
                this.load((InputStream)inputStream);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void store() throws IOException {
        log.debug("Storing: {}/{}", (Object)this.bucket, (Object)this.key);
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        this.store(bufferStream, null);
        byte[] buffer = bufferStream.toByteArray();
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)buffer.length);
        this.s3.putObject(this.bucket, this.key, (InputStream)new ByteArrayInputStream(buffer), metadata);
    }

    public boolean exists() throws IOException {
        return this.s3.doesObjectExist(this.bucket, this.key);
    }

    public void remove() throws IOException {
        this.s3.deleteObject(this.bucket, this.key);
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "bucket=" + this.bucket + ", key=" + this.key + '}';
    }

    public boolean equals(Object object) {
        if (object instanceof S3PropertiesFile) {
            S3PropertiesFile other = (S3PropertiesFile)((Object)object);
            return this.s3.equals(other.s3) && this.bucket.equals(other.bucket) && this.key.equals(other.key) && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.s3.hashCode() + this.bucket.hashCode() + this.key.hashCode() + super.hashCode();
    }
}

