/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.coreui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hibernate.validator.constraints.NotEmpty;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.coreui.AssetXO;
import org.sonatype.nexus.coreui.ComponentXO;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.extdirect.model.StoreLoadParameters;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseService;
import org.sonatype.nexus.repository.browse.QueryOptions;
import org.sonatype.nexus.repository.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentFinder;
import org.sonatype.nexus.repository.storage.ComponentStore;
import org.sonatype.nexus.repository.storage.DefaultComponentFinder;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.security.BreadActions;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.CselExpressionValidator;
import org.sonatype.nexus.selector.CselSelector;
import org.sonatype.nexus.selector.JexlExpressionValidator;
import org.sonatype.nexus.selector.JexlSelector;
import org.sonatype.nexus.selector.VariableSource;
import org.sonatype.nexus.validation.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
@DirectAction(action={"coreui_Component"})
public class ComponentComponent
extends DirectComponentSupport
implements GroovyObject {
    private static final Closure ASSET_CONVERTER;
    @Inject
    private SecurityHelper securityHelper;
    @Inject
    private RepositoryManager repositoryManager;
    @Inject
    private ContentPermissionChecker contentPermissionChecker;
    @Inject
    private VariableResolverAdapterManager variableResolverAdapterManager;
    @Inject
    private JexlExpressionValidator jexlExpressionValidator;
    @Inject
    private CselExpressionValidator cselExpressionValidator;
    @Inject
    private BrowseService browseService;
    @Inject
    private MaintenanceService maintenanceService;
    @Inject
    private ComponentStore componentStore;
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private Map<String, ComponentFinder> componentFinders;
    @Inject
    private BucketStore bucketStore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ComponentComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static final ComponentXO COMPONENT_CONVERTER(Component component, String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        return (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(ComponentXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[1].callGetProperty(callSiteArray[2].call(EntityHelper.class, (Object)component)), "repositoryName", repositoryName, "group", callSiteArray[3].call((Object)component), "name", callSiteArray[4].call((Object)component), "version", callSiteArray[5].call((Object)component), "format", callSiteArray[6].call((Object)component)})), ComponentXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    public List<AssetXO> readComponentAssets(StoreLoadParameters parameters) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        String repositoryName = ShortTypeHandling.castToString((Object)callSiteArray[7].call((Object)parameters, (Object)"repositoryName"));
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty((Object)repository)))) {
            return (List)ScriptBytecodeAdapter.castToType(null, List.class);
        }
        ComponentXO componentXO = (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call((Object)this.objectMapper, callSiteArray[12].call((Object)parameters, (Object)"componentModel"), ComponentXO.class), ComponentXO.class);
        ComponentFinder componentFinder = (ComponentFinder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call(this.componentFinders, callSiteArray[14].callGroovyObjectGetProperty((Object)componentXO)), ComponentFinder.class);
        if (ScriptBytecodeAdapter.compareEqual(null, (Object)componentFinder)) {
            Object object = callSiteArray[15].call(this.componentFinders, callSiteArray[16].callGetProperty(DefaultComponentFinder.class));
            componentFinder = (ComponentFinder)ScriptBytecodeAdapter.castToType((Object)object, ComponentFinder.class);
        }
        List components = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call((Object)componentFinder, ArrayUtil.createArray((Object)repository, (Object)callSiteArray[18].callGroovyObjectGetProperty((Object)componentXO), (Object)callSiteArray[19].callGroovyObjectGetProperty((Object)componentXO), (Object)callSiteArray[20].callGroovyObjectGetProperty((Object)componentXO), (Object)callSiteArray[21].callGroovyObjectGetProperty((Object)componentXO))), List.class);
        Object browseResult = callSiteArray[22].call((Object)this.browseService, (Object)repository, callSiteArray[23].call((Object)components, (Object)0));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callCurrent((GroovyObject)this, callSiteArray[25].callGetProperty(browseResult), callSiteArray[26].callGroovyObjectGetProperty((Object)componentXO), (Object)repository), List.class);
    }

    private List<Repository> getPreviewRepositories(RepositorySelector repositorySelector) {
        Reference repositorySelector2 = new Reference((Object)repositorySelector);
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callGetProperty((Object)((RepositorySelector)repositorySelector2.get())))) {
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call(ImmutableList.class, callSiteArray[29].call((Object)this.repositoryManager, callSiteArray[30].callGetProperty((Object)((RepositorySelector)repositorySelector2.get())))), List.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callGetProperty((Object)((RepositorySelector)repositorySelector2.get())))) {
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call(callSiteArray[33].call((Object)this.repositoryManager), (Object)new GeneratedClosure((Object)this, (Object)this, repositorySelector2){
                private /* synthetic */ Reference repositorySelector;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _getPreviewRepositories_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.repositorySelector = reference = repositorySelector;
                }

                public Object doCall(Repository repository) {
                    CallSite[] callSiteArray = _getPreviewRepositories_closure1.$getCallSiteArray();
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty((Object)repository)), (Object)callSiteArray[2].callGetProperty(this.repositorySelector.get())) ? repository : null;
                }

                public Object call(Repository repository) {
                    CallSite[] callSiteArray = _getPreviewRepositories_closure1.$getCallSiteArray();
                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)repository);
                }

                public RepositorySelector getRepositorySelector() {
                    CallSite[] callSiteArray = _getPreviewRepositories_closure1.$getCallSiteArray();
                    return (RepositorySelector)ScriptBytecodeAdapter.castToType((Object)this.repositorySelector.get(), RepositorySelector.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getPreviewRepositories_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "value";
                    stringArray[1] = "format";
                    stringArray[2] = "format";
                    stringArray[3] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _getPreviewRepositories_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getPreviewRepositories_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getPreviewRepositories_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call(callSiteArray[35].call((Object)this.repositoryManager)), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:selectors:*"})
    public PagedResponse<AssetXO> previewAssets(StoreLoadParameters parameters) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        String repositoryName = ShortTypeHandling.castToString((Object)callSiteArray[36].call((Object)parameters, (Object)"repositoryName"));
        String expression = ShortTypeHandling.castToString((Object)callSiteArray[37].call((Object)parameters, (Object)"expression"));
        String type = ShortTypeHandling.castToString((Object)callSiteArray[38].call((Object)parameters, (Object)"type"));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)expression) || !DefaultTypeTransformation.booleanUnbox((Object)type) || !DefaultTypeTransformation.booleanUnbox((Object)repositoryName) : !DefaultTypeTransformation.booleanUnbox((Object)expression) || !DefaultTypeTransformation.booleanUnbox((Object)type) || !DefaultTypeTransformation.booleanUnbox((Object)repositoryName)) {
            return (PagedResponse)ScriptBytecodeAdapter.castToType(null, PagedResponse.class);
        }
        RepositorySelector repositorySelector = (RepositorySelector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call(RepositorySelector.class, (Object)repositoryName), RepositorySelector.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)callSiteArray[40].callGetProperty(JexlSelector.class))) {
            callSiteArray[41].call((Object)this.jexlExpressionValidator, (Object)expression);
        } else if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)callSiteArray[42].callGetProperty(CselSelector.class))) {
            callSiteArray[43].call((Object)this.cselExpressionValidator, (Object)expression);
        }
        List selectedRepositories = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[44].callCurrent((GroovyObject)this, (Object)repositorySelector), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call((Object)selectedRepositories))) {
            return (PagedResponse)ScriptBytecodeAdapter.castToType(null, PagedResponse.class);
        }
        Object result = callSiteArray[46].call((Object)this.browseService, (Object)repositorySelector, (Object)selectedRepositories, (Object)expression, callSiteArray[47].callCurrent((GroovyObject)this, (Object)parameters));
        return (PagedResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].callConstructor(PagedResponse.class, callSiteArray[49].callGetProperty(result), callSiteArray[50].call(callSiteArray[51].callGetProperty(result), callSiteArray[52].call((Object)ASSET_CONVERTER, null, null, null, (Object)0))), PagedResponse.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    public PagedResponse<AssetXO> readAssets(StoreLoadParameters parameters) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        String repositoryName = ShortTypeHandling.castToString((Object)callSiteArray[53].call((Object)parameters, (Object)"repositoryName"));
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].callGetProperty(callSiteArray[56].callGetProperty((Object)repository)))) {
            return (PagedResponse)ScriptBytecodeAdapter.castToType(null, PagedResponse.class);
        }
        Object result = callSiteArray[57].call((Object)this.browseService, (Object)repository, callSiteArray[58].callCurrent((GroovyObject)this, (Object)parameters));
        return (PagedResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callConstructor(PagedResponse.class, callSiteArray[60].callGetProperty(result), callSiteArray[61].callCurrent((GroovyObject)this, callSiteArray[62].callGetProperty(result), null, (Object)repository)), PagedResponse.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public boolean canDeleteComponent(@NotEmpty String componentModelString) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        ComponentXO componentXO = (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call((Object)this.objectMapper, (Object)componentModelString, ComponentXO.class), ComponentXO.class);
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call((Object)this.repositoryManager, callSiteArray[65].callGroovyObjectGetProperty((Object)componentXO)), Repository.class);
        List components = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callCurrent((GroovyObject)this, (Object)componentXO, (Object)repository), List.class);
        Component component = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call((Object)components), Iterator.class);
        while (iterator.hasNext()) {
            component = (Component)ScriptBytecodeAdapter.castToType(iterator.next(), Component.class);
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].call((Object)this.maintenanceService, (Object)repository, (Object)component)))) continue;
            return false;
        }
        return true;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public Set<String> deleteComponent(@NotEmpty String componentModelString) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        ComponentXO componentXO = (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call((Object)this.objectMapper, (Object)componentModelString, ComponentXO.class), ComponentXO.class);
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call((Object)this.repositoryManager, callSiteArray[71].callGroovyObjectGetProperty((Object)componentXO)), Repository.class);
        List components = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callCurrent((GroovyObject)this, (Object)componentXO, (Object)repository), List.class);
        Set deletedAssets = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].callConstructor(HashSet.class), Set.class);
        Component component = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].call((Object)components), Iterator.class);
        while (iterator.hasNext()) {
            component = (Component)ScriptBytecodeAdapter.castToType(iterator.next(), Component.class);
            callSiteArray[75].call((Object)deletedAssets, callSiteArray[76].call((Object)this.maintenanceService, (Object)repository, (Object)component));
        }
        return deletedAssets;
    }

    private List<Component> getComponents(ComponentXO componentXO, Repository repository) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        ComponentFinder componentFinder = (ComponentFinder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].call(this.componentFinders, callSiteArray[78].callGroovyObjectGetProperty((Object)componentXO)), ComponentFinder.class);
        if (ScriptBytecodeAdapter.compareEqual(null, (Object)componentFinder)) {
            Object object = callSiteArray[79].call(this.componentFinders, callSiteArray[80].callGetProperty(DefaultComponentFinder.class));
            componentFinder = (ComponentFinder)ScriptBytecodeAdapter.castToType((Object)object, ComponentFinder.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call((Object)componentFinder, ArrayUtil.createArray((Object)repository, (Object)callSiteArray[82].callGroovyObjectGetProperty((Object)componentXO), (Object)callSiteArray[83].callGroovyObjectGetProperty((Object)componentXO), (Object)callSiteArray[84].callGroovyObjectGetProperty((Object)componentXO), (Object)callSiteArray[85].callGroovyObjectGetProperty((Object)componentXO))), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public boolean canDeleteAsset(@NotEmpty String assetId, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        Asset asset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].callCurrent((GroovyObject)this, (Object)assetId, (Object)repository), Asset.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)asset, null)) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].call((Object)this.maintenanceService, (Object)repository, (Object)asset));
        }
        return false;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public Set<String> deleteAsset(@NotEmpty String assetId, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        Asset asset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[90].callCurrent((GroovyObject)this, (Object)assetId, (Object)repository), Asset.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)asset, null)) {
            return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call((Object)this.maintenanceService, (Object)repository, (Object)asset), Set.class);
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].call(Collections.class), Set.class);
    }

    private Asset getAsset(String assetId, Repository repository) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Asset asset = null;
        StorageTx storageTx = (StorageTx)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call((Object)repository, StorageFacet.class))), StorageTx.class);
        try {
            callSiteArray[96].call((Object)storageTx);
            Object object = callSiteArray[97].call((Object)storageTx, callSiteArray[98].callConstructor(DetachedEntityId.class, (Object)assetId), callSiteArray[99].call((Object)storageTx, (Object)repository));
            asset = (Asset)ScriptBytecodeAdapter.castToType((Object)object, Asset.class);
        }
        catch (Throwable throwable) {
            callSiteArray[101].call((Object)storageTx);
            throw throwable;
        }
        callSiteArray[100].call((Object)storageTx);
        return asset;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @Nullable
    public ComponentXO readComponent(@NotEmpty String componentId, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        StorageTx storageTx = (StorageTx)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call((Object)repository, StorageFacet.class))), StorageTx.class);
        Component component = null;
        List assets = null;
        try {
            callSiteArray[106].call((Object)storageTx);
            Object object = callSiteArray[107].call((Object)storageTx, callSiteArray[108].callConstructor(DetachedEntityId.class, (Object)componentId));
            component = (Component)ScriptBytecodeAdapter.castToType((Object)object, Component.class);
            if (ScriptBytecodeAdapter.compareEqual((Object)component, null)) {
                throw (Throwable)callSiteArray[109].callConstructor(WebApplicationException.class, callSiteArray[110].callGetProperty(Response.Status.class));
            }
            Iterable browsedAssets = (Iterable)ScriptBytecodeAdapter.castToType((Object)callSiteArray[111].call((Object)storageTx, (Object)component), Iterable.class);
            if (ScriptBytecodeAdapter.compareEqual((Object)browsedAssets, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[112].call(Iterables.class, (Object)browsedAssets))) {
                throw (Throwable)callSiteArray[113].callConstructor(WebApplicationException.class, callSiteArray[114].callGetProperty(Response.Status.class));
            }
            Object object2 = callSiteArray[115].call(Lists.class, (Object)browsedAssets);
            assets = (List)ScriptBytecodeAdapter.castToType((Object)object2, List.class);
        }
        catch (Throwable throwable) {
            callSiteArray[117].call((Object)storageTx);
            throw throwable;
        }
        callSiteArray[116].call((Object)storageTx);
        callSiteArray[118].callCurrent((GroovyObject)this, (Object)repository, (Object)assets, callSiteArray[119].callGetProperty(BreadActions.class));
        return (ComponentXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].callStatic(ComponentComponent.class, (Object)component, callSiteArray[121].callGetProperty((Object)repository)), ComponentXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @Nullable
    public AssetXO readAsset(@NotEmpty String assetId, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[122].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        Asset asset = (Asset)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call((Object)this.browseService, callSiteArray[124].callConstructor(DetachedEntityId.class, (Object)assetId), (Object)repository), Asset.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)asset, null)) {
            throw (Throwable)callSiteArray[125].callConstructor(WebApplicationException.class, callSiteArray[126].callGetProperty(Response.Status.class));
        }
        String permittedRepositoryName = ShortTypeHandling.castToString((Object)callSiteArray[127].callCurrent((GroovyObject)this, callSiteArray[128].call((Object)this.repositoryManager, callSiteArray[129].callGetProperty(callSiteArray[130].call((Object)this.bucketStore, callSiteArray[131].call((Object)asset)))), callSiteArray[132].call(Collections.class, (Object)asset), callSiteArray[133].callGetProperty(BreadActions.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)asset)) {
            Object lastThirty = callSiteArray[134].call((Object)this.browseService, (Object)asset);
            return (AssetXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].call((Object)ASSET_CONVERTER, ArrayUtil.createArray((Object)asset, null, (Object)repositoryName, (Object)permittedRepositoryName, (Object)lastThirty)), AssetXO.class);
        }
        return (AssetXO)ScriptBytecodeAdapter.castToType(null, AssetXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public boolean canDeleteFolder(@NotEmpty String path, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[136].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[137].call((Object)this.maintenanceService, (Object)repository, (Object)path));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public void deleteFolder(@NotEmpty String path, @NotEmpty String repositoryName) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Repository repository = (Repository)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].call((Object)this.repositoryManager, (Object)repositoryName), Repository.class);
        callSiteArray[139].call((Object)this.maintenanceService, (Object)repository, (Object)path);
    }

    private QueryOptions toQueryOptions(StoreLoadParameters storeLoadParameters) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        Object sort = callSiteArray[140].callSafe(callSiteArray[141].callGetProperty((Object)storeLoadParameters), (Object)0);
        return (QueryOptions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].callConstructor(QueryOptions.class, ArrayUtil.createArray((Object)callSiteArray[143].call((Object)storeLoadParameters, (Object)"filter"), (Object)callSiteArray[144].callGetPropertySafe(sort), (Object)callSiteArray[145].callGetPropertySafe(sort), (Object)callSiteArray[146].callGetProperty((Object)storeLoadParameters), (Object)callSiteArray[147].callGetProperty((Object)storeLoadParameters))), QueryOptions.class);
    }

    private String ensurePermissions(Repository repository, Iterable<Asset> assets, String action) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        callSiteArray[148].callStatic(Preconditions.class, (Object)repository);
        callSiteArray[149].callStatic(Preconditions.class, assets);
        callSiteArray[150].callStatic(Preconditions.class, (Object)action);
        VariableResolverAdapter variableResolverAdapter = (VariableResolverAdapter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].call((Object)this.variableResolverAdapterManager, callSiteArray[152].callGetProperty(callSiteArray[153].callGetProperty((Object)repository))), VariableResolverAdapter.class);
        List repositoryNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[154].call((Object)this.repositoryManager, callSiteArray[155].callGetProperty((Object)repository)), List.class);
        callSiteArray[156].call((Object)repositoryNames, (Object)0, callSiteArray[157].callGetProperty((Object)repository));
        Asset asset = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[158].call(assets), Iterator.class);
        while (iterator.hasNext()) {
            asset = (Asset)ScriptBytecodeAdapter.castToType(iterator.next(), Asset.class);
            VariableSource variableSource = (VariableSource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[159].call((Object)variableResolverAdapter, (Object)asset), VariableSource.class);
            String repositoryName = ShortTypeHandling.castToString((Object)callSiteArray[160].callCurrent((GroovyObject)this, (Object)repositoryNames, callSiteArray[161].callGetProperty(callSiteArray[162].callGetProperty((Object)repository)), (Object)action, (Object)variableSource));
            if (!DefaultTypeTransformation.booleanUnbox((Object)repositoryName)) continue;
            return repositoryName;
        }
        throw (Throwable)callSiteArray[163].callConstructor(AuthorizationException.class);
    }

    private List<AssetXO> createAssetXOs(List<Asset> assets, String componentName, Repository repository) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        List assetXOs = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].callConstructor(ArrayList.class), List.class);
        Asset asset = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].call(assets), Iterator.class);
        while (iterator.hasNext()) {
            asset = (Asset)ScriptBytecodeAdapter.castToType(iterator.next(), Asset.class);
            Object lastThirty = callSiteArray[166].call((Object)this.browseService, (Object)asset);
            Object privilegedRepositoryName = callSiteArray[167].callCurrent((GroovyObject)this, (Object)repository, (Object)asset);
            callSiteArray[168].call((Object)assetXOs, callSiteArray[169].call((Object)ASSET_CONVERTER, ArrayUtil.createArray((Object)asset, (Object)componentName, (Object)callSiteArray[170].callGetProperty((Object)repository), (Object)privilegedRepositoryName, (Object)lastThirty)));
        }
        return assetXOs;
    }

    private String getPrivilegedRepositoryName(Repository repository, Asset asset) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        VariableResolverAdapter variableResolverAdapter = (VariableResolverAdapter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].call((Object)this.variableResolverAdapterManager, callSiteArray[172].callGetProperty(callSiteArray[173].callGetProperty((Object)repository))), VariableResolverAdapter.class);
        VariableSource variableSource = (VariableSource)ScriptBytecodeAdapter.castToType((Object)callSiteArray[174].call((Object)variableResolverAdapter, (Object)asset), VariableSource.class);
        String assetRepositoryName = ShortTypeHandling.castToString((Object)callSiteArray[175].callGetProperty(callSiteArray[176].call((Object)this.bucketStore, callSiteArray[177].call((Object)asset))));
        List repositoryNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[178].call((Object)this.repositoryManager, (Object)assetRepositoryName), List.class);
        callSiteArray[179].call((Object)repositoryNames, (Object)0, (Object)assetRepositoryName);
        return ShortTypeHandling.castToString((Object)callSiteArray[180].callCurrent((GroovyObject)this, (Object)repositoryNames, callSiteArray[181].callGetProperty(callSiteArray[182].callGetProperty((Object)repository)), callSiteArray[183].callGetProperty(BreadActions.class), (Object)variableSource));
    }

    private String getPrivilegedRepositoryName(List<String> repositoryNames, String format, String action, VariableSource variableSource) {
        CallSite[] callSiteArray = ComponentComponent.$getCallSiteArray();
        String repositoryName = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[184].call(repositoryNames), Iterator.class);
        while (iterator.hasNext()) {
            repositoryName = ShortTypeHandling.castToString(iterator.next());
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[185].call((Object)this.contentPermissionChecker, (Object)repositoryName, (Object)format, (Object)action, (Object)variableSource))) continue;
            return repositoryName;
        }
        return ShortTypeHandling.castToString(null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ComponentComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        GeneratedClosure generatedClosure = new GeneratedClosure(ComponentComponent.class, ComponentComponent.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = __clinit__closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Asset asset, String componentName, String repositoryName, String privilegedRepositoryName, long lastThirty) {
                CallSite[] callSiteArray = __clinit__closure2.$getCallSiteArray();
                Object[] objectArray = new Object[32];
                objectArray[0] = "id";
                objectArray[1] = callSiteArray[1].callGetProperty(callSiteArray[2].call(EntityHelper.class, (Object)asset));
                objectArray[2] = "name";
                Object object = callSiteArray[3].call((Object)asset);
                objectArray[3] = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : componentName;
                objectArray[4] = "format";
                objectArray[5] = callSiteArray[4].call((Object)asset);
                objectArray[6] = "contentType";
                Object object2 = callSiteArray[5].call((Object)asset);
                objectArray[7] = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : "unknown";
                objectArray[8] = "size";
                Object object3 = callSiteArray[6].call((Object)asset);
                objectArray[9] = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : Integer.valueOf(0);
                objectArray[10] = "repositoryName";
                objectArray[11] = repositoryName;
                objectArray[12] = "containingRepositoryName";
                objectArray[13] = privilegedRepositoryName;
                objectArray[14] = "blobCreated";
                objectArray[15] = callSiteArray[7].callSafe(callSiteArray[8].call((Object)asset));
                objectArray[16] = "blobUpdated";
                objectArray[17] = callSiteArray[9].callSafe(callSiteArray[10].call((Object)asset));
                objectArray[18] = "lastDownloaded";
                objectArray[19] = callSiteArray[11].callSafe(callSiteArray[12].call((Object)asset));
                objectArray[20] = "blobRef";
                objectArray[21] = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)asset)) ? callSiteArray[14].call(callSiteArray[15].call((Object)asset)) : "";
                objectArray[22] = "componentId";
                objectArray[23] = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call((Object)asset)) ? callSiteArray[17].callGetProperty(callSiteArray[18].call((Object)asset)) : "";
                objectArray[24] = "attributes";
                objectArray[25] = callSiteArray[19].call(callSiteArray[20].call((Object)asset));
                objectArray[26] = "downloadCount";
                objectArray[27] = lastThirty;
                objectArray[28] = "createdBy";
                objectArray[29] = callSiteArray[21].call((Object)asset);
                objectArray[30] = "createdByIp";
                objectArray[31] = callSiteArray[22].call((Object)asset);
                return callSiteArray[0].callConstructor(AssetXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray));
            }

            public Object call(Asset asset, String componentName, String repositoryName, String privilegedRepositoryName, long lastThirty) {
                CallSite[] callSiteArray = __clinit__closure2.$getCallSiteArray();
                return callSiteArray[23].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)asset, (Object)componentName, (Object)repositoryName, (Object)privilegedRepositoryName, (Object)lastThirty));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "value";
                stringArray[2] = "id";
                stringArray[3] = "name";
                stringArray[4] = "format";
                stringArray[5] = "contentType";
                stringArray[6] = "size";
                stringArray[7] = "toDate";
                stringArray[8] = "blobCreated";
                stringArray[9] = "toDate";
                stringArray[10] = "blobUpdated";
                stringArray[11] = "toDate";
                stringArray[12] = "lastDownloaded";
                stringArray[13] = "blobRef";
                stringArray[14] = "toString";
                stringArray[15] = "blobRef";
                stringArray[16] = "componentId";
                stringArray[17] = "value";
                stringArray[18] = "componentId";
                stringArray[19] = "backing";
                stringArray[20] = "attributes";
                stringArray[21] = "createdBy";
                stringArray[22] = "createdByIp";
                stringArray[23] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[24];
                __clinit__closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__clinit__closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
        ASSET_CONVERTER = generatedClosure;
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public ContentPermissionChecker getContentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public void setContentPermissionChecker(ContentPermissionChecker contentPermissionChecker) {
        this.contentPermissionChecker = contentPermissionChecker;
    }

    public VariableResolverAdapterManager getVariableResolverAdapterManager() {
        return this.variableResolverAdapterManager;
    }

    public void setVariableResolverAdapterManager(VariableResolverAdapterManager variableResolverAdapterManager) {
        this.variableResolverAdapterManager = variableResolverAdapterManager;
    }

    public JexlExpressionValidator getJexlExpressionValidator() {
        return this.jexlExpressionValidator;
    }

    public void setJexlExpressionValidator(JexlExpressionValidator jexlExpressionValidator) {
        this.jexlExpressionValidator = jexlExpressionValidator;
    }

    public CselExpressionValidator getCselExpressionValidator() {
        return this.cselExpressionValidator;
    }

    public void setCselExpressionValidator(CselExpressionValidator cselExpressionValidator) {
        this.cselExpressionValidator = cselExpressionValidator;
    }

    public BrowseService getBrowseService() {
        return this.browseService;
    }

    public void setBrowseService(BrowseService browseService) {
        this.browseService = browseService;
    }

    public MaintenanceService getMaintenanceService() {
        return this.maintenanceService;
    }

    public void setMaintenanceService(MaintenanceService maintenanceService) {
        this.maintenanceService = maintenanceService;
    }

    public ComponentStore getComponentStore() {
        return this.componentStore;
    }

    public void setComponentStore(ComponentStore componentStore) {
        this.componentStore = componentStore;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Map<String, ComponentFinder> getComponentFinders() {
        return this.componentFinders;
    }

    public void setComponentFinders(Map<String, ComponentFinder> map) {
        this.componentFinders = map;
    }

    public BucketStore getBucketStore() {
        return this.bucketStore;
    }

    public void setBucketStore(BucketStore bucketStore) {
        this.bucketStore = bucketStore;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "value";
        stringArray[2] = "id";
        stringArray[3] = "group";
        stringArray[4] = "name";
        stringArray[5] = "version";
        stringArray[6] = "format";
        stringArray[7] = "getFilter";
        stringArray[8] = "get";
        stringArray[9] = "online";
        stringArray[10] = "configuration";
        stringArray[11] = "readValue";
        stringArray[12] = "getFilter";
        stringArray[13] = "get";
        stringArray[14] = "format";
        stringArray[15] = "get";
        stringArray[16] = "DEFAULT_COMPONENT_FINDER_KEY";
        stringArray[17] = "findMatchingComponents";
        stringArray[18] = "id";
        stringArray[19] = "group";
        stringArray[20] = "name";
        stringArray[21] = "version";
        stringArray[22] = "browseComponentAssets";
        stringArray[23] = "get";
        stringArray[24] = "createAssetXOs";
        stringArray[25] = "results";
        stringArray[26] = "name";
        stringArray[27] = "allRepositories";
        stringArray[28] = "of";
        stringArray[29] = "get";
        stringArray[30] = "name";
        stringArray[31] = "allFormats";
        stringArray[32] = "findResults";
        stringArray[33] = "browse";
        stringArray[34] = "collect";
        stringArray[35] = "browse";
        stringArray[36] = "getFilter";
        stringArray[37] = "getFilter";
        stringArray[38] = "getFilter";
        stringArray[39] = "fromSelector";
        stringArray[40] = "TYPE";
        stringArray[41] = "validate";
        stringArray[42] = "TYPE";
        stringArray[43] = "validate";
        stringArray[44] = "getPreviewRepositories";
        stringArray[45] = "size";
        stringArray[46] = "previewAssets";
        stringArray[47] = "toQueryOptions";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "total";
        stringArray[50] = "collect";
        stringArray[51] = "results";
        stringArray[52] = "rcurry";
        stringArray[53] = "getFilter";
        stringArray[54] = "get";
        stringArray[55] = "online";
        stringArray[56] = "configuration";
        stringArray[57] = "browseAssets";
        stringArray[58] = "toQueryOptions";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "total";
        stringArray[61] = "createAssetXOs";
        stringArray[62] = "results";
        stringArray[63] = "readValue";
        stringArray[64] = "get";
        stringArray[65] = "repositoryName";
        stringArray[66] = "getComponents";
        stringArray[67] = "iterator";
        stringArray[68] = "canDeleteComponent";
        stringArray[69] = "readValue";
        stringArray[70] = "get";
        stringArray[71] = "repositoryName";
        stringArray[72] = "getComponents";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "iterator";
        stringArray[75] = "addAll";
        stringArray[76] = "deleteComponent";
        stringArray[77] = "get";
        stringArray[78] = "format";
        stringArray[79] = "get";
        stringArray[80] = "DEFAULT_COMPONENT_FINDER_KEY";
        stringArray[81] = "findMatchingComponents";
        stringArray[82] = "id";
        stringArray[83] = "group";
        stringArray[84] = "name";
        stringArray[85] = "version";
        stringArray[86] = "get";
        stringArray[87] = "getAsset";
        stringArray[88] = "canDeleteAsset";
        stringArray[89] = "get";
        stringArray[90] = "getAsset";
        stringArray[91] = "deleteAsset";
        stringArray[92] = "emptySet";
        stringArray[93] = "get";
        stringArray[94] = "txSupplier";
        stringArray[95] = "facet";
        stringArray[96] = "begin";
        stringArray[97] = "findAsset";
        stringArray[98] = "<$constructor$>";
        stringArray[99] = "findBucket";
        stringArray[100] = "close";
        stringArray[101] = "close";
        stringArray[102] = "get";
        stringArray[103] = "get";
        stringArray[104] = "txSupplier";
        stringArray[105] = "facet";
        stringArray[106] = "begin";
        stringArray[107] = "findComponent";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "NOT_FOUND";
        stringArray[111] = "browseAssets";
        stringArray[112] = "isEmpty";
        stringArray[113] = "<$constructor$>";
        stringArray[114] = "NOT_FOUND";
        stringArray[115] = "newArrayList";
        stringArray[116] = "close";
        stringArray[117] = "close";
        stringArray[118] = "ensurePermissions";
        stringArray[119] = "BROWSE";
        stringArray[120] = "COMPONENT_CONVERTER";
        stringArray[121] = "name";
        stringArray[122] = "get";
        stringArray[123] = "getAssetById";
        stringArray[124] = "<$constructor$>";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "NOT_FOUND";
        stringArray[127] = "ensurePermissions";
        stringArray[128] = "get";
        stringArray[129] = "repositoryName";
        stringArray[130] = "getById";
        stringArray[131] = "bucketId";
        stringArray[132] = "singletonList";
        stringArray[133] = "BROWSE";
        stringArray[134] = "getLastThirtyDays";
        stringArray[135] = "call";
        stringArray[136] = "get";
        stringArray[137] = "canDeleteFolder";
        stringArray[138] = "get";
        stringArray[139] = "deleteFolder";
        stringArray[140] = "get";
        stringArray[141] = "sort";
        stringArray[142] = "<$constructor$>";
        stringArray[143] = "getFilter";
        stringArray[144] = "property";
        stringArray[145] = "direction";
        stringArray[146] = "start";
        stringArray[147] = "limit";
        stringArray[148] = "checkNotNull";
        stringArray[149] = "checkNotNull";
        stringArray[150] = "checkNotNull";
        stringArray[151] = "get";
        stringArray[152] = "value";
        stringArray[153] = "format";
        stringArray[154] = "findContainingGroups";
        stringArray[155] = "name";
        stringArray[156] = "add";
        stringArray[157] = "name";
        stringArray[158] = "iterator";
        stringArray[159] = "fromAsset";
        stringArray[160] = "getPrivilegedRepositoryName";
        stringArray[161] = "value";
        stringArray[162] = "format";
        stringArray[163] = "<$constructor$>";
        stringArray[164] = "<$constructor$>";
        stringArray[165] = "iterator";
        stringArray[166] = "getLastThirtyDays";
        stringArray[167] = "getPrivilegedRepositoryName";
        stringArray[168] = "add";
        stringArray[169] = "call";
        stringArray[170] = "name";
        stringArray[171] = "get";
        stringArray[172] = "value";
        stringArray[173] = "format";
        stringArray[174] = "fromAsset";
        stringArray[175] = "repositoryName";
        stringArray[176] = "getById";
        stringArray[177] = "bucketId";
        stringArray[178] = "findContainingGroups";
        stringArray[179] = "add";
        stringArray[180] = "getPrivilegedRepositoryName";
        stringArray[181] = "value";
        stringArray[182] = "format";
        stringArray[183] = "BROWSE";
        stringArray[184] = "iterator";
        stringArray[185] = "isPermitted";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[186];
        ComponentComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ComponentComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ComponentComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

