/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.coreui.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.fileupload.FileItem;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.ComponentUploadExtension;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.upload.WithUploadField;
import org.sonatype.nexus.repository.view.PartPayload;

@Named
@Singleton
public class UploadService
extends ComponentSupport {
    private UploadManager uploadManager;
    private RepositoryManager repositoryManager;
    private final Set<ComponentUploadExtension> componentUploadExtensions;

    @Inject
    public UploadService(RepositoryManager repositoryManager, UploadManager uploadManager, Set<ComponentUploadExtension> componentsUploadExtensions) {
        this.uploadManager = (UploadManager)Preconditions.checkNotNull((Object)uploadManager);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.componentUploadExtensions = (Set)Preconditions.checkNotNull(componentsUploadExtensions);
    }

    public Collection<UploadDefinition> getAvailableDefinitions() {
        return this.uploadManager.getAvailableDefinitions();
    }

    public String upload(Map<String, String> params, Map<String, FileItem> files) throws IOException {
        Preconditions.checkNotNull(params);
        Preconditions.checkNotNull(files);
        String repositoryName = (String)Preconditions.checkNotNull((Object)params.get("repositoryName"), (Object)"Missing repositoryName parameter");
        Repository repository = (Repository)Preconditions.checkNotNull((Object)this.repositoryManager.get(repositoryName), (Object)"Specified repository is missing");
        ComponentUpload componentUpload = this.createAndValidate(repository, params, files);
        for (ComponentUploadExtension componentUploadExtension : this.componentUploadExtensions) {
            componentUploadExtension.validate(componentUpload);
        }
        UploadResponse uploadResponse = this.uploadManager.handle(repository, componentUpload);
        for (ComponentUploadExtension componentUploadExtension : this.componentUploadExtensions) {
            componentUploadExtension.apply(repository, componentUpload, (Collection)uploadResponse.getComponentIds());
        }
        return this.createSearchTerm(uploadResponse.getAssetPaths());
    }

    private ComponentUpload createAndValidate(Repository repository, Map<String, String> params, Map<String, FileItem> files) {
        ComponentUpload uc = new ComponentUpload();
        UploadDefinition ud = this.uploadManager.getByFormat(repository.getFormat().toString());
        this.createFields((WithUploadField)uc, ud.getComponentFields(), "", params);
        for (Map.Entry<String, FileItem> file : files.entrySet()) {
            String suffix = file.getKey().substring("file".length());
            AssetUpload ua = new AssetUpload();
            this.createFields((WithUploadField)ua, ud.getAssetFields(), suffix, params);
            FileItem fileItem = file.getValue();
            ua.setPayload((PartPayload)new FileItemPayload(fileItem));
            uc.getAssetUploads().add(ua);
        }
        this.logUploadDetails(uc, repository.getName(), repository.getFormat().getValue());
        return uc;
    }

    private void createFields(WithUploadField item, List<UploadFieldDefinition> fields, String suffix, Map<String, String> params) {
        for (UploadFieldDefinition assetField : fields) {
            String formField = String.valueOf(assetField.getName()) + suffix;
            String value = params.get(formField);
            if (Strings2.isEmpty((String)value)) continue;
            if (UploadFieldDefinition.Type.BOOLEAN.equals((Object)assetField.getType())) {
                item.getFields().put(assetField.getName(), "on".equals(value) ? "true" : "false");
                continue;
            }
            item.getFields().put(assetField.getName(), value);
        }
    }

    private void logUploadDetails(ComponentUpload componentUpload, String repository, String format) {
        Map componentFields = componentUpload.getFields();
        List assetUploads = componentUpload.getAssetUploads();
        StringBuilder sb = new StringBuilder();
        sb.append("Uploading component with parameters: ").append("repository").append("=\"").append(repository).append("\" ").append("format").append("=\"").append(format).append("\" ");
        for (Map.Entry entry : componentFields.entrySet()) {
            sb.append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\" ");
        }
        this.log.info(sb.toString());
        for (AssetUpload assetUpload : assetUploads) {
            sb = new StringBuilder();
            sb.append("Asset with parameters: ");
            sb.append("file=\"").append(assetUpload.getPayload().getName()).append("\" ");
            for (Map.Entry entry : assetUpload.getFields().entrySet()) {
                sb.append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\" ");
            }
            this.log.info(sb.toString());
        }
    }

    @VisibleForTesting
    String createSearchTerm(Collection<String> createdPaths) {
        if (createdPaths.isEmpty()) {
            return null;
        }
        String prefix = (String)Iterables.getFirst(createdPaths, null);
        for (String path : createdPaths) {
            prefix = this.longestPrefix(prefix, path);
        }
        return this.elasticEscape(prefix);
    }

    private String removeLastSegment(String path) {
        int index = path.lastIndexOf(47);
        if (index != -1) {
            return path.substring(0, index);
        }
        return path;
    }

    private String elasticEscape(String query) {
        return query.replace("/", "\\/").replace(".", "\\.").replace("-", "\\-");
    }

    private String longestPrefix(String prefix, String path) {
        String result = prefix;
        while (result.length() > 0 && !path.startsWith(result)) {
            result = this.removeLastSegment(result);
        }
        return result;
    }

    private static class FileItemPayload
    implements PartPayload {
        private final FileItem fileItem;

        FileItemPayload(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        public InputStream openInputStream() throws IOException {
            return this.fileItem.getInputStream();
        }

        public long getSize() {
            return this.fileItem.getSize();
        }

        public String getContentType() {
            return this.fileItem.getContentType();
        }

        public String getName() {
            return this.fileItem.getName();
        }

        public String getFieldName() {
            return this.fileItem.getFieldName();
        }

        public boolean isFormField() {
            return true;
        }
    }
}

