/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.coreui.internal.log;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.log.LogManager;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/logging/log")
public class LogResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/logging/log";
    private final LogManager logManager;

    @Inject
    public LogResource(LogManager logManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
    }

    @GET
    @Produces(value={"text/plain"})
    @RequiresPermissions(value={"nexus:logging:read"})
    public Response get(@QueryParam(value="fromByte") Long fromByte, @QueryParam(value="bytesCount") Long bytesCount) throws Exception {
        InputStream log;
        Long count;
        Long from = fromByte;
        if (from == null || from < 0L) {
            from = 0L;
        }
        if ((count = bytesCount) == null) {
            count = Long.MAX_VALUE;
        }
        if ((log = this.logManager.getLogFileStream("nexus.log", from.longValue(), count.longValue())) == null) {
            throw new NotFoundException("nexus.log not found");
        }
        return Response.ok((Object)log).header("Content-Disposition", (Object)"attachment; filename=\"nexus.log\"").build();
    }
}

