/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sonatype.insight.rm.rest.RestClientConfiguration;
import com.sonatype.nexus.clm.ClmAuthenticationType;
import com.sonatype.nexus.clm.ClmConfiguration;
import com.sonatype.nexus.clm.internal.capability.ClmCapability;
import com.sonatype.nexus.clm.internal.capability.ClmCapabilityDescriptor;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.PreemptiveAuthHttpRequestInterceptor;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConfigurationCustomizer;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@Named
@Singleton
public class ClmConnector
extends ComponentSupport {
    private final CapabilityRegistry capabilityRegistry;
    private final HttpClientManager httpClientManager;

    @Inject
    public ClmConnector(CapabilityRegistry capabilityRegistry, HttpClientManager httpClientManager) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
    }

    @Nullable
    public ClmConfiguration getConfiguration() {
        return this.getClmCapabilityReference().map(capabilityReference -> (ClmConfiguration)((Object)((Object)((ClmCapability)capabilityReference.capabilityAs(ClmCapability.class)).getConfig()))).orElse(null);
    }

    public boolean isConfigured() {
        return this.getConfiguration() != null;
    }

    public boolean isActive() {
        return this.getClmCapabilityReference().map(capabilityReference -> capabilityReference.context().isActive()).orElse(false);
    }

    public boolean isEnabled() {
        return this.getClmCapabilityReference().map(capabilityReference -> capabilityReference.context().isEnabled()).orElse(false);
    }

    public ClmConnector configure(ClmConfiguration configuration, @Nullable Boolean enabled) throws IOException {
        Optional<CapabilityReference> capabilityReference = this.getClmCapabilityReference();
        if (capabilityReference.isPresent()) {
            CapabilityReference reference = capabilityReference.get();
            this.capabilityRegistry.update(reference.context().id(), enabled != null ? enabled.booleanValue() : reference.context().isEnabled(), reference.context().notes(), configuration.asMap());
        } else {
            this.capabilityRegistry.add(ClmCapabilityDescriptor.TYPE, enabled != null ? enabled : true, null, configuration.asMap());
        }
        return this;
    }

    private Optional<CapabilityReference> getClmCapabilityReference() {
        return this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(ClmCapabilityDescriptor.TYPE)).stream().findFirst();
    }

    public RestClientConfiguration getRestConfiguration() {
        ClmConfiguration config = this.getConfiguration();
        Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"IQ Server has not been configured");
        if (ClmAuthenticationType.PKI == config.getAuthenticationType()) {
            return this.getRestConfiguration(config.getUrl(), config.getUseTrustStore(), config.getTimeout());
        }
        return this.getRestConfiguration(config.getUrl(), config.getUseTrustStore(), config.getTimeout(), config.getUsername(), config.getPassword());
    }

    public RestClientConfiguration getRestConfiguration(String url, boolean useTrustStore, Integer timeout) {
        return this.getRestConfiguration(url, useTrustStore, timeout, null, null);
    }

    public RestClientConfiguration getRestConfiguration(String url, boolean useTrustStore, Integer timeout, String username, String password) {
        RestClientConfiguration result = new RestClientConfiguration();
        result.setServerUrl(url);
        result.setHttpClientProvider(this.getHttpClientProvider(useTrustStore, timeout, username, password));
        return result;
    }

    RestClientConfiguration.HttpClientProvider getHttpClientProvider(final boolean useTrustStore, final Integer timeout, final String username, final String password) {
        return new RestClientConfiguration.HttpClientProvider(){

            public HttpClientBuilder createHttpClient(RestClientConfiguration restClientConfiguration) {
                HttpClientConfiguration configuration = new HttpClientConfiguration();
                if (username != null) {
                    UsernameAuthenticationConfiguration authentication = new UsernameAuthenticationConfiguration();
                    authentication.setUsername(username);
                    authentication.setPassword(password);
                    configuration.setAuthentication((AuthenticationConfiguration)authentication);
                }
                ConnectionConfiguration connection = new ConnectionConfiguration();
                configuration.setConnection(connection);
                connection.setUseTrustStore(Boolean.valueOf(useTrustStore));
                connection.setEnableCookies(Boolean.valueOf(true));
                if (timeout != null) {
                    connection.setTimeout(Time.seconds((long)timeout.intValue()));
                }
                return ClmConnector.this.httpClientManager.prepare((HttpClientPlan.Customizer)new ConfigurationCustomizer(configuration){

                    public void customize(HttpClientPlan plan) {
                        super.customize(plan);
                        plan.getClient().useSystemProperties();
                        plan.getClient().addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthHttpRequestInterceptor());
                    }
                });
            }
        };
    }
}

