/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.hash.HashCode;
import com.sonatype.nexus.clm.internal.AttributeUtils;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class AssetAttributeStorage
extends ComponentSupport {
    public static final String ASSET_AUDIT_TIMESTAMP_KEY = "auditAssetTimestamp";
    public static final String ASSET_EVALUATED_HASH_KEY = "evaluated-hash";
    public static final String ASSET_QUARANTINE_STATUS_KEY = "quarantine-status";

    public void setAuditTimestamp(Asset asset, long timestamp) {
        NestedAttributesMap attributes = this.getFirewallAttributes(asset);
        attributes.set(ASSET_AUDIT_TIMESTAMP_KEY, (Object)Long.toString(timestamp));
        attributes.set(ASSET_EVALUATED_HASH_KEY, (Object)Objects.toString(asset.getChecksum(HashAlgorithm.SHA1), null));
    }

    @Nullable
    public Long getAuditTimestamp(Asset asset) {
        if (Objects.equals(asset.getChecksum(HashAlgorithm.SHA1), this.getEvaluatedHash(asset))) {
            return AttributeUtils.tryParse(this.getAttribute(asset, ASSET_AUDIT_TIMESTAMP_KEY), Long::valueOf);
        }
        return null;
    }

    @Nullable
    public Long reloadAuditTimestamp(Repository repository, Asset asset) {
        return (Long)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset storedAsset = tx.findAsset(EntityHelper.id((Entity)asset));
            if (storedAsset != null && Objects.equals(asset.getChecksum(HashAlgorithm.SHA1), storedAsset.getChecksum(HashAlgorithm.SHA1))) {
                return this.getAuditTimestamp(storedAsset);
            }
            return null;
        });
    }

    public void setQuarantineStatus(Asset asset, QuarantineStatus status, @Nullable Long timestamp) {
        NestedAttributesMap attributes = this.getFirewallAttributes(asset);
        attributes.set(ASSET_QUARANTINE_STATUS_KEY, (Object)status.name());
        attributes.set(ASSET_EVALUATED_HASH_KEY, (Object)Objects.toString(asset.getChecksum(HashAlgorithm.SHA1), null));
        if (timestamp != null) {
            attributes.set(ASSET_AUDIT_TIMESTAMP_KEY, (Object)timestamp.toString());
        }
    }

    @Nullable
    public QuarantineStatus getQuarantineStatus(Asset asset) {
        if (Objects.equals(asset.getChecksum(HashAlgorithm.SHA1), this.getEvaluatedHash(asset))) {
            return AttributeUtils.tryParse(this.getAttribute(asset, ASSET_QUARANTINE_STATUS_KEY), QuarantineStatus::valueOf);
        }
        return null;
    }

    @Nullable
    public QuarantineStatus reloadQuarantineStatus(Repository repository, Asset asset) {
        return (QuarantineStatus)((Object)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset storedAsset = tx.findAsset(EntityHelper.id((Entity)asset));
            if (storedAsset != null && Objects.equals(asset.getChecksum(HashAlgorithm.SHA1), storedAsset.getChecksum(HashAlgorithm.SHA1))) {
                return this.getQuarantineStatus(storedAsset);
            }
            return null;
        }));
    }

    @Nullable
    public HashCode getEvaluatedHash(Asset asset) {
        return AttributeUtils.tryParse(this.getAttribute(asset, ASSET_EVALUATED_HASH_KEY), HashCode::fromString);
    }

    private String getAttribute(Asset asset, String key) {
        return (String)this.getFirewallAttributes(asset).get(key, String.class);
    }

    private NestedAttributesMap getFirewallAttributes(Asset asset) {
        return asset.attributes().child("firewall");
    }
}

