/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.RetryWhitelist;
import com.sonatype.nexus.clm.internal.SleepService;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;

@Named
public class AuditRetryStrategy
extends ComponentSupport {
    private static final long MAX_TOTAL_RETRY_TIME = Time.minutes((long)15L).toMillis();
    private static final long MAX_RETRY_TIME = Time.seconds((long)30L).toMillis();
    private final SleepService sleepService;
    private final RetryWhitelist retryWhitelist;
    private int retryCount = 0;
    private long delay = 1000L;
    private long totalDelay;

    @Inject
    public AuditRetryStrategy(SleepService sleepService, RetryWhitelist retryWhitelist) {
        this.sleepService = (SleepService)((Object)Preconditions.checkNotNull((Object)((Object)sleepService)));
        this.retryWhitelist = (RetryWhitelist)((Object)Preconditions.checkNotNull((Object)((Object)retryWhitelist)));
    }

    public boolean retryRequest(Exception exception) {
        ++this.retryCount;
        if (!this.retryWhitelist.doRetry(exception)) {
            this.log.debug("Retry retryCount={}, the exception is not whitelisted, retryRequest=false", (Object)this.retryCount);
            return false;
        }
        if (this.totalDelay > MAX_TOTAL_RETRY_TIME) {
            this.log.debug("Retry retryCount={}, totalDelay={} exceeded the maximum allowed of {}, retryRequest=false", new Object[]{this.retryCount, this.totalDelay, MAX_TOTAL_RETRY_TIME});
            return false;
        }
        this.delay = Math.min(MAX_RETRY_TIME, (long)((double)this.delay * 1.5));
        this.totalDelay += this.delay;
        try {
            this.sleepService.sleep(this.delay);
        }
        catch (InterruptedException e) {
            this.log.debug("Retry interrupted, retryRequest=false", (Throwable)e);
            return false;
        }
        this.log.debug("Retry retryCount={}, retryRequest=true", (Object)this.retryCount);
        return true;
    }
}

