/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.entity.ConflictState;
import org.sonatype.nexus.orient.entity.DeconflictStepSupport;
import org.sonatype.nexus.repository.storage.Asset;

@Named
@Singleton
public class DeconflictAssetFirewallAttributes
extends DeconflictStepSupport<Asset> {
    private static final String FIREWALL_ATTRIBUTES = "attributes.firewall";
    private static final String QUARANTINE_STATUS_ATTRIBUTE = "attributes.firewall.quarantine-status";
    private static final String EVALUATED_HASH_ATTRIBUTE = "attributes.firewall.evaluated-hash";
    private static final String AUDIT_TIMESTAMP_ATTRIBUTE = "attributes.firewall.auditAssetTimestamp";

    public ConflictState deconflict(ODocument storedRecord, ODocument changeRecord) {
        Object storedFirewall = storedRecord.rawField(FIREWALL_ATTRIBUTES);
        Object changeFirewall = changeRecord.rawField(FIREWALL_ATTRIBUTES);
        if (storedFirewall != null && changeFirewall != null) {
            return DeconflictAssetFirewallAttributes.pickNonNull((ODocument)storedRecord, (ODocument)changeRecord, (String)QUARANTINE_STATUS_ATTRIBUTE).andThen(() -> DeconflictAssetFirewallAttributes.pickNonNull((ODocument)storedRecord, (ODocument)changeRecord, (String)EVALUATED_HASH_ATTRIBUTE).andThen(() -> DeconflictAssetFirewallAttributes.pickLatest((ODocument)storedRecord, (ODocument)changeRecord, (String)AUDIT_TIMESTAMP_ATTRIBUTE)));
        }
        if (changeFirewall != null) {
            storedRecord.field(FIREWALL_ATTRIBUTES, changeFirewall);
            return ConflictState.ALLOW;
        }
        if (storedFirewall != null) {
            changeRecord.field(FIREWALL_ATTRIBUTES, storedFirewall);
            return ConflictState.MERGE;
        }
        return ConflictState.IGNORE;
    }
}

