/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.AssetAttributeStorage;
import com.sonatype.nexus.clm.internal.EvaluationSender;
import com.sonatype.nexus.clm.internal.FirewallCooperation;
import com.sonatype.nexus.clm.internal.IQErrorManager;
import com.sonatype.nexus.clm.internal.IsAssetAuditable;
import com.sonatype.nexus.clm.internal.IsAssetQuarantinable;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.UnquarantinedComponentsUpdater;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.handlers.ContributedHandler;

@Named
@Singleton
public class FirewallContributedHandler
extends ComponentSupport
implements ContributedHandler {
    static final String ASSET_IS_QUARANTINED_ERROR_MESSAGE = "Requested item is quarantined";
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final AssetAttributeStorage assetAttributeStorage;
    private final IsAssetAuditable isAssetAuditable;
    private final IsAssetQuarantinable isAssetQuarantinable;
    private final FirewallCooperation cooperation;
    private final EvaluationSender evaluationSender;
    private final UnquarantinedComponentsUpdater unquarantinedComponentsUpdater;
    private final IQErrorManager iqErrorManager;

    @Inject
    public FirewallContributedHandler(RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, IsAssetAuditable isAssetAuditable, IsAssetQuarantinable isAssetQuarantinable, FirewallCooperation cooperation, EvaluationSender evaluationSender, UnquarantinedComponentsUpdater unquarantinedComponentsUpdater, IQErrorManager iqErrorManager) {
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)repositoryAttributeStorage)));
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
        this.isAssetAuditable = (IsAssetAuditable)Preconditions.checkNotNull((Object)isAssetAuditable);
        this.isAssetQuarantinable = (IsAssetQuarantinable)Preconditions.checkNotNull((Object)isAssetQuarantinable);
        this.cooperation = (FirewallCooperation)((Object)Preconditions.checkNotNull((Object)((Object)cooperation)));
        this.evaluationSender = (EvaluationSender)((Object)Preconditions.checkNotNull((Object)((Object)evaluationSender)));
        this.unquarantinedComponentsUpdater = (UnquarantinedComponentsUpdater)((Object)Preconditions.checkNotNull((Object)((Object)unquarantinedComponentsUpdater)));
        this.iqErrorManager = (IQErrorManager)((Object)Preconditions.checkNotNull((Object)((Object)iqErrorManager)));
    }

    public Response handle(Context context) throws Exception {
        Response response = context.proceed();
        String action = context.getRequest().getAction();
        if (("GET".equals(action) || "HEAD".equals(action)) && response.getStatus().isSuccessful()) {
            Asset asset = this.getAssetFromPayload(response.getPayload());
            Repository repository = context.getRepository();
            if (this.repositoryAttributeStorage.isAuditEnabled(repository.getName()) && this.isAssetAuditable.test(asset)) {
                if (this.isAssetQuarantinable.test(repository, asset)) {
                    QuarantineStatus quarantineStatus = this.checkQuarantineStatus(repository, asset);
                    if (quarantineStatus != QuarantineStatus.ALLOW) {
                        this.log.info("Blocked serving of quarantined asset {}:{} because quarantineStatus={}", new Object[]{repository.getName(), asset.name(), quarantineStatus != null ? quarantineStatus : "PENDING"});
                        response = HttpResponses.forbidden((String)ASSET_IS_QUARANTINED_ERROR_MESSAGE);
                        response.getAttributes().set("USE_DISPATCHED_RESPONSE", (Object)true);
                    }
                } else {
                    this.checkAuditStatus(repository, asset);
                }
            }
        }
        return response;
    }

    @Nullable
    private Asset getAssetFromPayload(Payload payload) {
        if (payload instanceof Content) {
            return (Asset)((Content)payload).getAttributes().get(Asset.class);
        }
        return null;
    }

    @Nullable
    private QuarantineStatus checkQuarantineStatus(Repository repository, Asset asset) {
        QuarantineStatus status = this.assetAttributeStorage.getQuarantineStatus(asset);
        if (status == QuarantineStatus.ALLOW) {
            return status;
        }
        String repositoryName = repository.getName();
        try {
            this.iqErrorManager.reset(repositoryName);
            if (status == null) {
                status = this.sendQuarantineRequest(repository, asset);
            } else if (status == QuarantineStatus.DENY) {
                status = this.sendUnquarantineRequest(repository, asset);
            }
        }
        catch (IOException | RuntimeException e) {
            this.log.warn("Could not get latest quarantine status for asset {}:{}: {}", new Object[]{repository.getName(), asset.name(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
            this.iqErrorManager.addErrorMessage(repositoryName, e);
            status = null;
        }
        return status;
    }

    private QuarantineStatus sendQuarantineRequest(Repository repository, Asset asset) throws IOException {
        String reason;
        String string = reason = asset.isNew() ? "new_component" : "reevaluation";
        if (!this.cooperation.isEnabled()) {
            return this.evaluationSender.sendQuarantineRequest(asset, repository, reason);
        }
        return (QuarantineStatus)((Object)this.cooperation.cooperate(String.valueOf(repository.getName()) + ':' + asset.name(), failover -> {
            QuarantineStatus status;
            if (failover && (status = (QuarantineStatus)((Object)((Object)this.cooperation.join(() -> this.assetAttributeStorage.reloadQuarantineStatus(repository, asset))))) != null) {
                return status;
            }
            return this.evaluationSender.sendQuarantineRequest(asset, repository, reason);
        }));
    }

    @Nullable
    private QuarantineStatus sendUnquarantineRequest(Repository repository, Asset asset) throws IOException {
        if (!this.cooperation.isEnabled()) {
            this.unquarantinedComponentsUpdater.requestAndUpdateUnquarantinedComponents(repository);
            return this.assetAttributeStorage.reloadQuarantineStatus(repository, asset);
        }
        return (QuarantineStatus)((Object)this.cooperation.cooperate(repository.getName(), failover -> {
            if (failover) {
                return (QuarantineStatus)((Object)((Object)this.cooperation.join(() -> this.assetAttributeStorage.reloadQuarantineStatus(repository, asset))));
            }
            this.unquarantinedComponentsUpdater.requestAndUpdateUnquarantinedComponents(repository);
            return this.assetAttributeStorage.reloadQuarantineStatus(repository, asset);
        }));
    }

    private void checkAuditStatus(Repository repository, Asset asset) {
        Long assetAuditTimestamp = this.assetAttributeStorage.getAuditTimestamp(asset);
        if (assetAuditTimestamp == null) {
            DateTime blobUpdatedTime;
            String repositoryName = repository.getName();
            Long repositoryAuditTimestamp = this.repositoryAttributeStorage.getAuditTimestamp(repositoryName);
            if (repositoryAuditTimestamp != null && ((blobUpdatedTime = asset.blobUpdated()) == null || blobUpdatedTime.isBefore(repositoryAuditTimestamp.longValue()))) {
                return;
            }
            try {
                this.iqErrorManager.reset(repositoryName);
                this.sendAuditRequest(repository, asset);
            }
            catch (IOException | RuntimeException e) {
                this.log.warn("Problem notifying IQ server of proxied asset {}:{}: {}", new Object[]{repository.getName(), asset.name(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
                this.iqErrorManager.addErrorMessage(repositoryName, e);
            }
        }
    }

    private Void sendAuditRequest(Repository repository, Asset asset) throws IOException {
        String reason;
        String string = reason = asset.isNew() ? "new_component" : "reevaluation";
        if (!this.cooperation.isEnabled()) {
            this.evaluationSender.sendAuditRequest(asset, repository, reason);
            return null;
        }
        return (Void)this.cooperation.cooperate(String.valueOf(repository.getName()) + ':' + asset.name(), failover -> {
            Long timestamp;
            if (failover && (timestamp = (Long)this.cooperation.join(() -> this.assetAttributeStorage.reloadAuditTimestamp(repository, asset))) != null) {
                return null;
            }
            this.evaluationSender.sendAuditRequest(asset, repository, reason);
            return null;
        });
    }
}

