/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Suppliers;
import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;

@Named
@Singleton
public class FirewallCooperation
extends ComponentSupport {
    @Nullable
    private final Supplier<Cooperation> cooperationSupplier;

    @Inject
    public FirewallCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.firewall.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.firewall.cooperation.timeout:-60s}") Time cooperationTimeout) {
        this.cooperationSupplier = cooperationEnabled ? Suppliers.memoize(() -> cooperationFactory.configure().majorTimeout(cooperationTimeout).minorTimeout(cooperationTimeout).build("firewall")) : null;
    }

    public boolean isEnabled() {
        return this.cooperationSupplier != null;
    }

    public <T> T cooperate(String requestKey, Cooperation.IOCall<T> request) throws IOException {
        return (T)this.cooperationSupplier.get().cooperate(requestKey, request);
    }

    @Nullable
    public <T> T join(Cooperation.IOCheck<T> request) throws IOException {
        return (T)this.cooperationSupplier.get().join(request);
    }
}

