/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.annotations.VisibleForTesting;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatterns;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsCreatedEvent;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsDeletedEvent;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsUpdatedEvent;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.SingletonEntityAdapter;

@Named
@Singleton
public class FirewallIgnorePatternsEntityAdapter
extends SingletonEntityAdapter<FirewallIgnorePatterns> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("firewall").type("ignore_patterns").build();
    @VisibleForTesting
    static final String P_REGEXPS_BY_FORMAT = "regexps_by_format";

    public FirewallIgnorePatternsEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REGEXPS_BY_FORMAT, OType.EMBEDDEDMAP).setMandatory(true).setNotNull(true);
    }

    protected FirewallIgnorePatterns newEntity() {
        return new FirewallIgnorePatterns();
    }

    protected void readFields(ODocument document, FirewallIgnorePatterns entity) throws Exception {
        entity.setRegexpsByFormat((Map)document.field(P_REGEXPS_BY_FORMAT, OType.EMBEDDEDMAP));
    }

    protected void writeFields(ODocument document, FirewallIgnorePatterns entity) throws Exception {
        document.field(P_REGEXPS_BY_FORMAT, entity.getRegexpsByFormat());
    }

    public FirewallIgnorePatterns get(ODatabaseDocumentTx db) {
        FirewallIgnorePatterns entity = (FirewallIgnorePatterns)super.get(db);
        if (entity == null) {
            entity = this.newEntity();
        }
        return entity;
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        Map regexpsByFormat = (Map)document.field(P_REGEXPS_BY_FORMAT, OType.EMBEDDEDMAP);
        this.log.debug("newEvent: eventKind: {}, regexpsByFormat: {}, metadata: {}", new Object[]{eventKind, regexpsByFormat, metadata});
        switch (eventKind) {
            case CREATE: {
                return new FirewallIgnorePatternsCreatedEvent((EntityMetadata)metadata, regexpsByFormat);
            }
            case UPDATE: {
                return new FirewallIgnorePatternsUpdatedEvent((EntityMetadata)metadata, regexpsByFormat);
            }
            case DELETE: {
                return new FirewallIgnorePatternsDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

