/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.internal.AttributeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.ImmutableNestedAttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.orient.ReplicationModeOverrides;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.manager.RepositoryMetadataUpdatedEvent;

@Named
@Singleton
public class RepositoryAttributeStorage
extends ComponentSupport
implements EventAware {
    private final RepositoryManager repositoryManager;
    private final Map<String, NestedAttributesMap> firewallAttributesCache;
    private final Set<String> repositoriesInError;

    @Inject
    RepositoryAttributeStorage(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.firewallAttributesCache = new ConcurrentHashMap<String, NestedAttributesMap>();
        this.repositoriesInError = ConcurrentHashMap.newKeySet();
    }

    public boolean isAuditEnabled(String repositoryName) {
        return Boolean.valueOf(this.getAttribute(repositoryName, "auditEnabled"));
    }

    public void setAuditEnabled(String repositoryName, boolean enable) {
        if (!enable && !this.isExisting(repositoryName)) {
            this.firewallAttributesCache.remove(repositoryName);
            this.repositoriesInError.remove(repositoryName);
            return;
        }
        boolean wasEnabled = this.isAuditEnabled(repositoryName);
        if (wasEnabled != enable) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (enable) {
                attributes.put("auditTimestamp", Long.toString(System.currentTimeMillis()));
            } else {
                attributes.put("auditTimestamp", null);
                attributes.put("quarantineEnabledTimestamp", null);
                attributes.put("quarantineLastUpdateTimestamp", null);
                attributes.put("lastServerError", null);
            }
            attributes.put("auditEnabled", Boolean.toString(enable));
            this.saveAttributes(repositoryName, attributes);
        }
    }

    @Nullable
    public Long getAuditTimestamp(String repositoryName) {
        return AttributeUtils.tryParse(this.getAttribute(repositoryName, "auditTimestamp"), Long::valueOf);
    }

    public void clearAuditTimestamp(String repositoryName) {
        if (this.getAuditTimestamp(repositoryName) != null) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("auditTimestamp", null);
            this.saveAttributes(repositoryName, attributes);
        }
    }

    public boolean isQuarantineEnabled(String repositoryName) {
        return this.getQuarantineEnabledTime(repositoryName) != null;
    }

    @Nullable
    public Long getQuarantineEnabledTime(String repositoryName) {
        return AttributeUtils.tryParse(this.getAttribute(repositoryName, "quarantineEnabledTimestamp"), Long::valueOf);
    }

    public void setQuarantineEnabled(String repositoryName, boolean enable) {
        boolean wasEnabled = this.isQuarantineEnabled(repositoryName);
        if (wasEnabled != enable) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (enable) {
                attributes.put("quarantineEnabledTimestamp", Long.toString(System.currentTimeMillis()));
            } else {
                attributes.put("quarantineEnabledTimestamp", null);
                attributes.put("quarantineLastUpdateTimestamp", null);
            }
            this.saveAttributes(repositoryName, attributes);
        }
    }

    @Nullable
    public Long getQuarantineLastUpdateTimestamp(String repositoryName) {
        Long timestamp = AttributeUtils.tryParse(this.getAttribute(repositoryName, "quarantineLastUpdateTimestamp"), Long::valueOf);
        return timestamp != null ? timestamp : this.getQuarantineEnabledTime(repositoryName);
    }

    public void setQuarantineLastUpdateTimestamp(String repositoryName, long timestamp) {
        if (this.isQuarantineEnabled(repositoryName)) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("quarantineLastUpdateTimestamp", Long.toString(timestamp));
            this.saveAttributes(repositoryName, attributes);
        }
    }

    @Nullable
    public String getLastServerError(String repositoryName) {
        return this.getAttribute(repositoryName, "lastServerError");
    }

    public void setLastServerError(String repositoryName, @Nullable String serverError) {
        if (this.updateErrorState(repositoryName, serverError)) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("lastServerError", serverError);
            ReplicationModeOverrides.dontWaitForReplicationResults();
            try {
                this.saveAttributes(repositoryName, attributes);
            }
            finally {
                ReplicationModeOverrides.clearReplicationModeOverrides();
            }
        }
    }

    public void clearLastServerError(String repositoryName) {
        this.setLastServerError(repositoryName, null);
    }

    public void clearAttributes(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            ((AttributesFacet)repository.facet(AttributesFacet.class)).modifyAttributes(attributes -> attributes.remove("firewall"));
        } else {
            this.firewallAttributesCache.remove(repositoryName);
            this.repositoriesInError.remove(repositoryName);
        }
    }

    @Subscribe
    public void onRepositoryMetadataUpdatedEvent(RepositoryMetadataUpdatedEvent event) {
        this.firewallAttributesCache.remove(event.getRepository().getName());
    }

    private boolean isExisting(String repositoryName) {
        return this.repositoryManager.get(repositoryName) != null;
    }

    @Nullable
    private String getAttribute(String repositoryName, String key) {
        NestedAttributesMap attributesCache = this.getAttributesCache(repositoryName);
        return attributesCache != null ? (String)attributesCache.get(key, String.class) : null;
    }

    @Nullable
    private NestedAttributesMap getAttributesCache(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            return this.firewallAttributesCache.computeIfAbsent(repositoryName, name -> {
                ImmutableNestedAttributesMap attributes = ((AttributesFacet)repository.facet(AttributesFacet.class)).getAttributes();
                NestedAttributesMap firewallAttributes = attributes.child("firewall");
                this.updateErrorState(repositoryName, firewallAttributes.get("lastServerError"));
                return firewallAttributes;
            });
        }
        return null;
    }

    private boolean updateErrorState(String repositoryName, @Nullable Object serverError) {
        if (serverError != null) {
            return this.repositoriesInError.add(repositoryName);
        }
        return this.repositoriesInError.remove(repositoryName);
    }

    private void saveAttributes(String repositoryName, Map<String, ?> attributeChanges) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            ((AttributesFacet)repository.facet(AttributesFacet.class)).modifyAttributes(attributes -> {
                NestedAttributesMap firewallAttributes = attributes.child("firewall");
                for (Map.Entry attribute : attributeChanges.entrySet()) {
                    if (attribute.getValue() != null) {
                        firewallAttributes.set((String)attribute.getKey(), attribute.getValue());
                        continue;
                    }
                    firewallAttributes.remove((String)attribute.getKey());
                }
            });
        } else {
            this.firewallAttributesCache.remove(repositoryName);
            this.repositoriesInError.remove(repositoryName);
        }
    }
}

